/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.common.util.UrnUtil;
import io.polyglotted.common.util.UuidUtil;
import io.polyglotted.elastic.common.DocStatus;
import java.util.Map;

public abstract class MetaFields {
    public static final String ALL_FIELD = "&all";
    public static final String ANCESTOR_FIELD = "&ancestor";
    public static final String APPROVAL_ROLES_FIELD = "&approvalRoles";
    public static final String AUTO_COMPLETE_FIELD = "&autoComplete";
    public static final String BASE_TS_FIELD = "&baseTimestamp";
    public static final String COMMENT_FIELD = "&comment";
    public static final String EXPIRY_FIELD = "&expiry";
    public static final String HIGHLTGHT_FIELD = "&highlight";
    public static final String INDEX_FIELD = "&index";
    public static final String ID_FIELD = "&id";
    public static final String KEY_FIELD = "&key";
    public static final String LINK_FIELD = "&link";
    public static final String MODEL_FIELD = "&model";
    public static final String PARENT_FIELD = "&parent";
    public static final String RESULT_FIELD = "&result";
    public static final String SCHEMA_FIELD = "&schema";
    public static final String SIZE_FIELD = "&size";
    public static final String STATUS_FIELD = "&status";
    public static final String TIMESTAMP_FIELD = "&timestamp";
    public static final String TRAITFQN_FIELD = "&traitFqn";
    public static final String TRAITID_FIELD = "&traitId";
    public static final String TTL_FIELD = "&ttlExpiry";
    public static final String UNIQUE_FIELD = "&uniqueProps";
    public static final String UPDATER_FIELD = "&updater";
    public static final String USER_FIELD = "&user";
    public static final String[] ALL_FIELDS = (String[])ListBuilder.immutableList((Object[])new String[]{"&ancestor", "&approvalRoles", "&baseTimestamp", "&comment", "&expiry", "&index", "&id", "&key", "&link", "&model", "&parent", "&schema", "&size", "&status", "&traitFqn", "&traitId", "&timestamp", "&ttlExpiry", "&updater", "&user"}).toArray((Object[])new String[0]);

    public static void addMeta(Object item, String field, Object value) {
        MetaFields.addMetaField(MetaFields.mapValue(item), field, value);
    }

    public static void addMetaField(MapResult mapValue, String field, Object value) {
        mapValue.put((Object)field, value);
    }

    public static void removeMeta(Object item, String field) {
        MetaFields.mapValue(item).remove((Object)field);
    }

    public static String reqdMeta(Object object, String field) {
        return MapRetriever.reqdStr((Map)MetaFields.mapValue(object), (String)field);
    }

    public static boolean isNotMeta(String field) {
        return field.indexOf(38) != 0;
    }

    public static String index(Object object) {
        return MetaFields.reqdMeta(object, INDEX_FIELD);
    }

    public static String model(Object object) {
        return MetaFields.reqdMeta(object, MODEL_FIELD);
    }

    public static String reqdId(Object object) {
        return MetaFields.reqdMeta(object, ID_FIELD);
    }

    public static String reqdKey(Object object) {
        return MetaFields.reqdMeta(object, KEY_FIELD);
    }

    public static String id(Object object) {
        return (String)MapRetriever.optValue((Map)MetaFields.mapValue(object), (String)ID_FIELD);
    }

    public static String parent(Object object) {
        return (String)MapRetriever.optValue((Map)MetaFields.mapValue(object), (String)PARENT_FIELD);
    }

    public static long timestamp(Object object) {
        return MapRetriever.longStrVal((Map)MetaFields.mapValue(object), (String)TIMESTAMP_FIELD, (long)-3L);
    }

    public static String keyString(MapResult map) {
        return UrnUtil.urnOf((String)MetaFields.model(map), (String)MetaFields.id(map));
    }

    public static String uniqueId(MapResult map) {
        return UrnUtil.safeUrnOf((Object[])new Object[]{MetaFields.model(map), MetaFields.parent(map), StrUtil.nullAsEmpty((String)MetaFields.id(map)), String.valueOf(MetaFields.timestamp(map))});
    }

    public static String genUniqueId(String model, String id, long timestamp) {
        return UuidUtil.genUuidStr((String)UrnUtil.safeUrnOf((Object[])new Object[]{model, id, String.valueOf(timestamp)}));
    }

    public static MapBuilder.ImmutableMapBuilder<String, Object> readKey(MapResult map) {
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder();
        MetaFields.putVal(map, LINK_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, (String)Assertions.checkContains((Map)map, (Object)MODEL_FIELD), (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, PARENT_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, (String)Assertions.checkContains((Map)map, (Object)ID_FIELD), (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putTs(map, (String)Assertions.checkContains((Map)map, (Object)TIMESTAMP_FIELD), (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        return builder;
    }

    public static MapResult readHeader(MapResult map) {
        return MetaFields.readHeader(map, true);
    }

    public static MapResult readHeader(MapResult map, boolean mandatory) {
        MapBuilder.ImmutableMapBuilder builder = MapResult.immutableResultBuilder();
        MetaFields.putVal(map, ANCESTOR_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, APPROVAL_ROLES_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putTs(map, BASE_TS_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, COMMENT_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putTs(map, EXPIRY_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, INDEX_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)ID_FIELD) : ID_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)KEY_FIELD) : KEY_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, LINK_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)MODEL_FIELD) : MODEL_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, PARENT_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, SCHEMA_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, SIZE_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        if (map.containsKey((Object)STATUS_FIELD)) {
            builder.put((Object)STATUS_FIELD, (Object)DocStatus.fromStatus(map.get((Object)STATUS_FIELD).toString()));
        }
        MetaFields.putVal(map, TRAITFQN_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, TRAITID_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putTs(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)TIMESTAMP_FIELD) : TIMESTAMP_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, TTL_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, UPDATER_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)USER_FIELD) : USER_FIELD, (MapBuilder.ImmutableMapBuilder<String, Object>)builder);
        return builder.result();
    }

    private static void putTs(MapResult map, String property, MapBuilder.ImmutableMapBuilder<String, Object> builder) {
        if (map.containsKey((Object)property)) {
            builder.put((Object)property, (Object)MapRetriever.longStrVal((Map)map, (String)property, (long)-3L));
        }
    }

    private static void putVal(MapResult map, String property, MapBuilder.ImmutableMapBuilder<String, Object> builder) {
        if (map.containsKey((Object)property)) {
            builder.put((Object)property, map.get((Object)property));
        }
    }

    private static MapResult mapValue(Object item) {
        return item instanceof MapResult ? (MapResult)item : (MapResult)NullUtil.nonNull((Object)ReflectionUtil.safeFieldValue((Object)item, (String)"_meta"), (Object)MapResult.simpleResult());
    }
}

