/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class EsAuth {
    @Nullable
    public final String user;
    @NonNull
    public final String creds;
    @NonNull
    public final AuthType type;

    public static EsAuth bearerToken(String token) {
        return new EsAuth(null, token, AuthType.BEARER);
    }

    public Header header() {
        return new BasicHeader("Authorization", this.type.header(this));
    }

    public EsAuth(@Nullable String user, @NonNull String creds, @NonNull AuthType type) {
        if (creds == null) {
            throw new NullPointerException("creds");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.user = user;
        this.creds = creds;
        this.type = type;
    }

    public static enum AuthType {
        BASIC{

            @Override
            String header(EsAuth auth) {
                return "Basic " + Base64.encodeBase64String((byte[])(auth.user + ":" + auth.creds).getBytes(StandardCharsets.UTF_8));
            }
        }
        ,
        BEARER{

            @Override
            String header(EsAuth auth) {
                return "Bearer " + auth.creds;
            }
        };


        abstract String header(EsAuth var1);
    }
}

