/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.elastic.admin.Field;
import io.polyglotted.elastic.admin.FieldType;
import io.polyglotted.elastic.admin.Type;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

abstract class TypeSerializer {
    TypeSerializer() {
    }

    static String serializeType(Type type) {
        return TypeSerializer.writeType(type, XContentFactory.jsonBuilder()).string();
    }

    private static XContentBuilder writeType(Type type, XContentBuilder gen) throws IOException {
        gen.startObject().field(type.type).startObject();
        if (type.strict) {
            gen.field("dynamic", "strict");
        }
        if (!type.enabled) {
            gen.field("enabled", false);
        } else {
            if (!type.meta.isEmpty()) {
                gen.field("_meta", (Map)type.meta);
            }
            if (!type.enableSource) {
                gen.field("_source").startObject().field("enabled", false).endObject();
            } else {
                if (type.includeMeta) {
                    gen.field("_source").startObject().field("excludes", type.sourceExcludes()).endObject();
                }
                TypeSerializer.writeFields("properties", CollUtil.uniqueIndex(TypeSerializer.typeValues(type), Field::field), gen);
            }
        }
        return gen.endObject().endObject();
    }

    private static Set<Field> typeValues(Type type) {
        return type.includeMeta ? ListBuilder.immutableSortedSet((Iterable)CollUtil.concat(TypeSerializer.metaFields(), type.fields)) : ListBuilder.immutableSortedSet(type.fields);
    }

    private static void writeFields(String name, Map<String, Field> fields, XContentBuilder gen) throws IOException {
        gen.field(name).startObject();
        for (Map.Entry<String, Field> entry : fields.entrySet()) {
            gen.field(entry.getKey());
            TypeSerializer.writeField(entry.getValue(), gen);
        }
        gen.endObject();
    }

    private static void writeField(Field field, XContentBuilder gen) throws IOException {
        gen.startObject();
        if (field.type != FieldType.OBJECT) {
            gen.field("type", field.type.validate(field));
        } else if (!field.hasProperties()) {
            gen.field("type", FieldType.OBJECT.validate(field));
        }
        if (field.hasFields()) {
            TypeSerializer.writeFields("fields", field.properties, gen);
        }
        TypeSerializer.writeNotNullOrEmpty(gen, "index", field.indexed);
        TypeSerializer.writeNotNullOrEmpty(gen, "store", field.stored);
        TypeSerializer.writeNotNullOrEmpty(gen, "doc_values", field.docValues);
        TypeSerializer.writeNotNullOrEmpty(gen, "analyzer", field.analyzer);
        if (field.copyToFields.size() > 0) {
            gen.field("copy_to", field.copyToFields);
        }
        for (Map.Entry arg : field.argsMap.entrySet()) {
            TypeSerializer.writeNotNullOrEmpty(gen, (String)arg.getKey(), arg.getValue());
        }
        if (field.hasProperties()) {
            TypeSerializer.writeFields("properties", field.properties, gen);
        }
        gen.endObject();
    }

    private static void writeNotNullOrEmpty(XContentBuilder builder, String key, Object value) throws IOException {
        if (value != null) {
            builder.field(key, value);
        }
    }

    private static List<Field> metaFields() {
        return ListBuilder.immutableList((Object[])new Field[]{Field.textField("&all", "allAnalyzer").build(), Field.keywordField("&ancestor").build(), Field.textField("&autoComplete", "autoAnalyzer").build(), Field.simpleField("&expiry", FieldType.DATE).build(), Field.keywordField("&id").normalise().build(), Field.keywordField("&key").normalise().build(), Field.keywordField("&link").build(), Field.keywordField("&model").normalise().build(), Field.keywordField("&parent").build(), Field.simpleField("&size", FieldType.LONG).build(), Field.keywordField("&status").build(), Field.simpleField("&timestamp", FieldType.DATE).build(), Field.keywordField("&traitFqn").build(), Field.keywordField("&traitId").build(), Field.keywordField("&uniqueProps").normalise().build(), Field.keywordField("&updater").build(), Field.keywordField("&user").build()});
    }
}

