/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.SortedMapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ResourceUtil;
import java.util.Map;

public final class IndexSetting {
    private static final String DEF_ANALYSIS = ResourceUtil.readResource(IndexSetting.class, (String)"def-analysis.json");
    public final MapResult.ImmutableResult mapResult;

    public String createJson() {
        return BaseSerializer.serialize((Object)CollUtil.filterKeysNeg((Map)this.mapResult, "index_name"::equals));
    }

    public static IndexSetting with(int numberOfShards, int numberOfReplicas) {
        return IndexSetting.settingBuilder(numberOfShards, numberOfReplicas).build();
    }

    public static IndexSetting autoReplicate() {
        return IndexSetting.settingBuilder().numberOfShards(1).autoExpandReplicas().analysis(DEF_ANALYSIS).ignoreMalformed().disableDynamicMapping().build();
    }

    public static Builder settingBuilder(int numShards, int numReplicas) {
        return IndexSetting.settingBuilder(numShards, numReplicas, DEF_ANALYSIS);
    }

    public static Builder settingBuilder(int numShards, int numReplicas, String analysis) {
        return IndexSetting.settingBuilder().analysis((String)NullUtil.nonNull((Object)analysis, (Object)DEF_ANALYSIS)).numberOfShards(numShards).numberOfReplicas(numReplicas).ignoreMalformed();
    }

    public static Builder settingBuilder() {
        return new Builder();
    }

    public IndexSetting(MapResult.ImmutableResult mapResult) {
        this.mapResult = mapResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSetting)) {
            return false;
        }
        IndexSetting other = (IndexSetting)o;
        MapResult.ImmutableResult this$mapResult = this.mapResult;
        MapResult.ImmutableResult other$mapResult = other.mapResult;
        return !(this$mapResult == null ? other$mapResult != null : !this$mapResult.equals(other$mapResult));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapResult.ImmutableResult $mapResult = this.mapResult;
        result = result * 59 + ($mapResult == null ? 43 : $mapResult.hashCode());
        return result;
    }

    public static class Builder {
        private final SortedMapResult treeResult = SortedMapResult.treeResult();

        public Builder numberOfShards(int numberOfShards) {
            this.treeResult.put((Object)"number_of_shards", (Object)numberOfShards);
            return this;
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.treeResult.put((Object)"number_of_replicas", (Object)numberOfReplicas);
            return this;
        }

        public Builder refreshInterval(long refreshInterval) {
            this.treeResult.put((Object)"refresh_interval", (Object)refreshInterval);
            return this;
        }

        public Builder ignoreMalformed() {
            this.treeResult.putIfAbsent((Object)"mapping.ignore_malformed", (Object)true);
            return this;
        }

        public Builder disableDynamicMapping() {
            this.treeResult.putIfAbsent((Object)"mapper.dynamic", (Object)false);
            return this;
        }

        public Builder autoExpandReplicas() {
            this.treeResult.putIfAbsent((Object)"auto_expand_replicas", (Object)"0-all");
            return this;
        }

        public Builder any(String name, Object value) {
            this.treeResult.put((Object)name, value);
            return this;
        }

        public Builder all(MapResult result) {
            this.treeResult.putAll((Map)result);
            return this;
        }

        public Builder analysis(String analysis) {
            this.treeResult.put((Object)"analysis", (Object)BaseSerializer.deserialize((String)analysis));
            return this;
        }

        public IndexSetting build() {
            return new IndexSetting((MapResult.ImmutableResult)this.treeResult.immutable());
        }

        private Builder() {
        }
    }
}

