/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.applauncher.settings;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import io.polyglotted.applauncher.crypto.CryptoClient;
import io.polyglotted.applauncher.settings.Attribute;
import io.polyglotted.applauncher.settings.Settings;
import io.polyglotted.applauncher.settings.SettingsException;
import io.polyglotted.applauncher.settings.SettingsHolder;
import java.beans.ConstructorProperties;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class DefaultSettingsHolder
implements SettingsHolder {
    private final Config config;
    private static final InvocationHandler MethodProxyInvocationHandler = DefaultSettingsHolder.methodProxyInvocationHandler();
    private static final Map<Class<?>, PropertyType<?>> DefaultPropertyTypes = ImmutableMap.builder().put(Integer.TYPE, (Object)new IntegerPropertyType()).put(Integer.class, (Object)new IntegerPropertyType()).put(Long.TYPE, (Object)new LongPropertyType()).put(Long.class, (Object)new LongPropertyType()).put(Boolean.TYPE, (Object)new BooleanPropertyType()).put(Boolean.class, (Object)new BooleanPropertyType()).put(Double.TYPE, (Object)new DoublePropertyType()).put(Double.class, (Object)new DoublePropertyType()).put(String.class, (Object)new StringPropertyType()).build();

    public DefaultSettingsHolder(String resource) {
        this(ConfigFactory.load((String)resource, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF), (ConfigResolveOptions)ConfigResolveOptions.defaults()));
    }

    public DefaultSettingsHolder(Map<String, Object> map) {
        this(ConfigFactory.parseMap(map));
    }

    public DefaultSettingsHolder() {
        this.config = ConfigFactory.load();
    }

    @Override
    public <T> T proxy(Class<T> configurationInterface) {
        try {
            if (!configurationInterface.isInterface()) {
                throw new SettingsException(configurationInterface.getName() + " is not an interface");
            }
            if (!Modifier.isPublic(configurationInterface.getModifiers())) {
                throw new SettingsException(configurationInterface.getName() + " is not public");
            }
            if (!configurationInterface.isAnnotationPresent(Settings.class)) {
                throw new SettingsException(configurationInterface.getName() + " must be annotated with @Settings annotation");
            }
            Class<?> proxyClass = Proxy.getProxyClass(configurationInterface.getClassLoader(), configurationInterface);
            InvocationHandlerImpl invocationHandler = this.buildInvocationHandler(configurationInterface);
            return (T)proxyClass.getConstructor(InvocationHandler.class).newInstance(invocationHandler);
        }
        catch (SettingsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SettingsException(e);
        }
    }

    @Override
    public Properties asProperties(String prefix, boolean includePrefix) {
        Properties props = new Properties();
        this.config.entrySet().parallelStream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).forEach(entry -> {
            String key = includePrefix ? (String)entry.getKey() : ((String)entry.getKey()).replace(prefix + ".", "");
            props.put(key, String.valueOf(((ConfigValue)entry.getValue()).unwrapped()));
        });
        return props;
    }

    @Override
    public boolean hasValue(String name) {
        return this.config.hasPath(name);
    }

    @Override
    public String stringValue(String name) {
        return this.config.getString(name);
    }

    @Override
    public int intValue(String name) {
        return this.config.getInt(name);
    }

    @Override
    public boolean booleanValue(String name) {
        return this.config.getBoolean(name);
    }

    @Override
    public long longValue(String name) {
        return this.config.getLong(name);
    }

    @Override
    public double doubleValue(String name) {
        return this.config.getDouble(name);
    }

    private <T> InvocationHandlerImpl buildInvocationHandler(Class<T> configurationInterface) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Method[] declaredMethods = DefaultSettingsHolder.fetchDeclaredMethods(configurationInterface);
        Object classProxy = Proxy.newProxyInstance(configurationInterface.getClassLoader(), new Class[]{configurationInterface}, MethodProxyInvocationHandler);
        CryptoClient cryptoClient = new CryptoClient();
        for (Method method : declaredMethods) {
            if (!method.isAnnotationPresent(Attribute.class)) continue;
            this.validateParameterTypes(method);
            Object value = this.resolvePropertyValue(method, classProxy, cryptoClient);
            result.put(method.getName(), value);
        }
        if (result.isEmpty()) {
            throw new SettingsException("No properties are defined in @Settings " + configurationInterface.getName());
        }
        return new InvocationHandlerImpl(classProxy, result);
    }

    private Object resolvePropertyValue(Method method, Object classProxy, CryptoClient cryptoClient) {
        Attribute propertyAnnotation = method.getAnnotation(Attribute.class);
        PropertyType propertyType = this.resolvePropertyType(method, propertyAnnotation.optional());
        String propertyName = propertyAnnotation.name();
        Optional<Object> value = Optional.empty();
        if (this.config.hasPath(propertyName)) {
            value = Optional.of(propertyType.getValue(this.config, propertyName));
        } else if (method.isDefault()) {
            value = Optional.of(method.invoke(classProxy, new Object[0]));
        }
        if (!value.isPresent() && !propertyAnnotation.optional()) {
            throw new SettingsException("Missing property " + propertyName + " expected in configuration " + method.getDeclaringClass().getName() + ".");
        }
        if (value.isPresent() && propertyAnnotation.encrypted()) {
            if (value.get().getClass() != String.class) {
                throw new SettingsException("Encrypted property " + propertyName + " is not a string.");
            }
            value = Optional.of(cryptoClient.decrypt((String)value.get()));
        }
        return propertyAnnotation.optional() ? value : value.get();
    }

    private PropertyType resolvePropertyType(Method method, boolean optional) {
        PropertyType<?> propertyType;
        Class<?> returnType = method.getReturnType();
        if (optional) {
            returnType = this.resolveOptionalPropertyType(method, returnType);
        }
        if ((propertyType = DefaultPropertyTypes.get(returnType)) == null) {
            throw new SettingsException("Method " + method.getName() + " of interface " + method.getDeclaringClass().getName() + " annotated with @Attribute has unsupported return type. Only the following types are supported: " + DefaultPropertyTypes.keySet());
        }
        return propertyType;
    }

    private Class<?> resolveOptionalPropertyType(Method method, Class<?> returnType) {
        if (!returnType.isAssignableFrom(Optional.class)) {
            throw new SettingsException("Method " + method.getName() + " of interface " + method.getDeclaringClass().getName() + " annotated with " + Attribute.class.getName() + " with Optional = true but has a return type different from java.util.Optional.");
        }
        Type returnTypeGeneric = method.getGenericReturnType();
        Type[] actualTypeArguments = ((ParameterizedType)returnTypeGeneric).getActualTypeArguments();
        returnType = (Class)actualTypeArguments[0];
        return returnType;
    }

    private void validateParameterTypes(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null && parameterTypes.length > 0) {
            throw new SettingsException("Attribute method declaration has parameters: " + method.getName() + " in configuration interface " + method.getDeclaringClass());
        }
    }

    private static InvocationHandler methodProxyInvocationHandler() {
        return (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(declaringClass);
                Field f = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
                int modifiers = f.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(f, modifiers & 0xFFFFFFEF);
                    f.setAccessible(true);
                    f.set(lookup, 2);
                }
                return lookup.unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
            }
            return null;
        };
    }

    private static Method[] fetchDeclaredMethods(Class<?> clazz) {
        LinkedList result = new LinkedList();
        Collections.addAll(result, clazz.getDeclaredMethods());
        for (Class<?> iface : clazz.getInterfaces()) {
            Collections.addAll(result, iface.getDeclaredMethods());
        }
        return result.toArray(new Method[result.size()]);
    }

    @ConstructorProperties(value={"config"})
    public DefaultSettingsHolder(Config config) {
        this.config = config;
    }

    @Override
    public Config config() {
        return this.config;
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private final Object classProxy;
        private final Map<String, Object> config;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if (this.config.containsKey(method.getName())) {
                return this.config.get(method.getName());
            }
            try {
                return method.invoke(this.classProxy, args);
            }
            catch (Exception ex) {
                throw new RuntimeException("unexpected invocation", ex);
            }
        }

        private InvocationHandlerImpl(Object classProxy, Map<String, Object> config) {
            this.classProxy = classProxy;
            this.config = config;
        }
    }

    private static class DoublePropertyType
    implements PropertyType<Double> {
        private DoublePropertyType() {
        }

        @Override
        public Double getValue(Config source, String property) {
            return source.getDouble(property);
        }
    }

    private static class LongPropertyType
    implements PropertyType<Long> {
        private LongPropertyType() {
        }

        @Override
        public Long getValue(Config source, String property) {
            return source.getLong(property);
        }
    }

    private static class BooleanPropertyType
    implements PropertyType<Boolean> {
        private BooleanPropertyType() {
        }

        @Override
        public Boolean getValue(Config source, String property) {
            return source.getBoolean(property);
        }
    }

    private static class IntegerPropertyType
    implements PropertyType<Integer> {
        private IntegerPropertyType() {
        }

        @Override
        public Integer getValue(Config source, String property) {
            return source.getInt(property);
        }
    }

    private static class StringPropertyType
    implements PropertyType<String> {
        private StringPropertyType() {
        }

        @Override
        public String getValue(Config source, String property) {
            return source.getString(property);
        }
    }

    private static interface PropertyType<T> {
        public T getValue(Config var1, String var2);
    }
}

