/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.applauncher.crypto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.UUID;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public final class CryptoClient {
    public static final String PASSWORD_SYSTEM_PROPERTY = "crypto.password";
    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";
    private final StringEncryptor encryptor;

    public CryptoClient() {
        this(CryptoClient.resolvePassword());
    }

    @VisibleForTesting
    public CryptoClient(String password) {
        this.encryptor = CryptoClient.createEncryptor(password);
    }

    public String encrypt(String toEncrypt) {
        return Strings.isNullOrEmpty((String)toEncrypt) ? toEncrypt : String.format("%s%s%s", PREFIX, this.encryptor.encrypt(toEncrypt), SUFFIX);
    }

    public String decrypt(String encrypted) {
        if (!Strings.isNullOrEmpty((String)encrypted) && encrypted.startsWith(PREFIX) && encrypted.endsWith(SUFFIX)) {
            encrypted = encrypted.substring(PREFIX.length(), encrypted.length() - SUFFIX.length());
            return this.encryptor.decrypt(encrypted);
        }
        return encrypted;
    }

    private static String resolvePassword() {
        String password = System.getProperty(PASSWORD_SYSTEM_PROPERTY);
        if (Strings.isNullOrEmpty((String)password)) {
            password = System.getenv(PASSWORD_SYSTEM_PROPERTY);
        }
        return Strings.isNullOrEmpty((String)password) ? UUID.randomUUID().toString() : password;
    }

    private static StringEncryptor createEncryptor(String password) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(password);
        encryptor.setAlgorithm("PBEWithMD5AndDES");
        return encryptor;
    }
}

