/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.shared.valueobject;

import com.google.common.base.CaseFormat;
import io.polygenesis.shared.assertion.Assertion;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.atteo.evo.inflector.English;

public class Text
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String original;
    private String modified;
    private String lowerCase;
    private String upperCase;
    private String upperUnderscore;
    private String lowerCamel;
    private String upperCamel;
    private String lowerHyphen;
    private String lowerCamelSpaces;
    private String upperCamelSpaces;
    private Text plural;

    public Text(String text) {
        this(text, true);
    }

    private Text(String text, boolean pluralize) {
        Assertion.isNotEmpty(text, "text cannot be empty");
        this.setOriginal(text);
        if (pluralize) {
            String pluralized = English.plural((String)this.getOriginal());
            this.plural = new Text(pluralized, false);
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public String getModified() {
        return this.modified;
    }

    public String getLowerCase() {
        return this.lowerCase;
    }

    public String getUpperCase() {
        return this.upperCase;
    }

    public String getUpperUnderscore() {
        return this.upperUnderscore;
    }

    public String getLowerCamel() {
        return this.lowerCamel;
    }

    public String getUpperCamel() {
        return this.upperCamel;
    }

    public String getLowerHyphen() {
        return this.lowerHyphen;
    }

    public String getLowerCamelSpaces() {
        return this.lowerCamelSpaces;
    }

    public String getUpperCamelSpaces() {
        return this.upperCamelSpaces;
    }

    public Text getPlural() {
        return this.plural;
    }

    private String underscoreToLowerCamel(String input) {
        if (input.contains("_")) {
            StringBuilder sb = new StringBuilder(input.toLowerCase());
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != '_') continue;
                sb.deleteCharAt(i);
                sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
            }
            return sb.toString();
        }
        return input;
    }

    private String allUpperCaseToLowerCase(String input) {
        if (StringUtils.isAllUpperCase((CharSequence)input)) {
            return input.toLowerCase();
        }
        return input;
    }

    private void setOriginal(String text) {
        this.original = text;
        this.setModified(text);
        this.setLowerCamel(this.getModified());
        this.setUpperCamel(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, this.getModified()));
        this.setUpperUnderscore(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this.getModified()));
        this.setLowerHyphen(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getModified()));
        this.setLowerCase(this.getModified().toLowerCase());
        this.setUpperCase(this.getModified().toUpperCase());
        this.setLowerCamelSpaces(StringUtils.replaceAll((String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getModified()), (String)"-", (String)" "));
        this.setUpperCamelSpaces(StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)this.getUpperCamel()), (char)' '));
    }

    private void setModified(String original) {
        int index = original.lastIndexOf(46);
        this.modified = index > 0 ? original.substring(index + 1) : original;
        this.modified = this.underscoreToLowerCamel(this.modified);
        this.modified = this.allUpperCaseToLowerCase(this.modified);
        this.modified = this.modified.substring(0, 1).toLowerCase() + this.modified.substring(1);
    }

    private void setUpperCamelSpaces(String upperCamelSpaces) {
        this.upperCamelSpaces = upperCamelSpaces;
    }

    private void setLowerCamelSpaces(String lowerCamelSpaces) {
        this.lowerCamelSpaces = lowerCamelSpaces;
    }

    private void setUpperCase(String upper) {
        this.upperCase = upper;
    }

    private void setLowerHyphen(String lowerHyphen) {
        this.lowerHyphen = lowerHyphen;
    }

    private void setLowerCase(String lower) {
        this.lowerCase = lower;
    }

    private void setLowerCamel(String lowerCamel) {
        this.lowerCamel = lowerCamel;
    }

    private void setUpperUnderscore(String upperUnderscore) {
        this.upperUnderscore = upperUnderscore;
    }

    private void setUpperCamel(String upperCamel) {
        this.upperCamel = upperCamel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Text text = (Text)o;
        return new EqualsBuilder().append((Object)this.original, (Object)text.original).append((Object)this.modified, (Object)text.modified).append((Object)this.lowerCase, (Object)text.lowerCase).append((Object)this.upperCase, (Object)text.upperCase).append((Object)this.upperUnderscore, (Object)text.upperUnderscore).append((Object)this.lowerCamel, (Object)text.lowerCamel).append((Object)this.upperCamel, (Object)text.upperCamel).append((Object)this.lowerHyphen, (Object)text.lowerHyphen).append((Object)this.lowerCamelSpaces, (Object)text.lowerCamelSpaces).append((Object)this.upperCamelSpaces, (Object)text.upperCamelSpaces).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.original).append((Object)this.modified).append((Object)this.lowerCase).append((Object)this.upperCase).append((Object)this.upperUnderscore).append((Object)this.lowerCamel).append((Object)this.upperCamel).append((Object)this.lowerHyphen).append((Object)this.lowerCamelSpaces).append((Object)this.upperCamelSpaces).toHashCode();
    }
}

