/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.system.model.core.iomodel;

import io.polygenesis.shared.assertion.Assertion;
import io.polygenesis.shared.valueobject.Text;
import io.polygenesis.system.model.core.iomodel.IoModel;
import io.polygenesis.system.model.core.iomodel.IoModelArray;
import io.polygenesis.system.model.core.iomodel.IoModelPrimitive;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class IoModelGroup
extends IoModel {
    private Set<IoModel> models;

    public IoModelGroup(IoModelGroup parent) {
        super(parent);
        this.setModels(new LinkedHashSet<IoModel>());
    }

    public IoModelGroup(Text genericType, Text dataType, Text variableName) {
        super(genericType, dataType, variableName);
        this.setModels(new LinkedHashSet<IoModel>());
    }

    public boolean addIoModelPrimitive(IoModelPrimitive model) {
        return this.models.add(model);
    }

    public boolean addIoModelGroup(IoModelGroup model) {
        return this.models.add(model);
    }

    public boolean addIoModelArray(IoModelArray model) {
        return this.models.add(model);
    }

    public Set<IoModel> getModels() {
        return this.models;
    }

    private void setModels(Set<IoModel> models) {
        Assertion.isNotNull(models, (String)"models is required");
        this.models = models;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoModelGroup that = (IoModelGroup)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.models, that.models).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).toHashCode();
    }
}

