/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.system.model.core.iomodel;

import io.polygenesis.shared.valueobject.Text;
import io.polygenesis.system.model.core.iomodel.IoModelArray;
import io.polygenesis.system.model.core.iomodel.IoModelGroup;
import io.polygenesis.system.model.core.iomodel.IoModelPrimitive;
import io.polygenesis.system.model.core.iomodel.ModelPrimitiveType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class IoModel {
    private Text genericType;
    private Text dataType;
    private Text variableName;
    private IoModelGroup parent;

    public IoModel(IoModelGroup parent) {
        this.setParent(parent);
    }

    public IoModel(Text dataType, Text variableName) {
        this.setDataType(dataType);
        this.setVariableName(variableName);
    }

    public IoModel(Text dataType, Text variableName, IoModelGroup parent) {
        this(dataType, variableName);
        this.setParent(parent);
    }

    public IoModel(Text genericType, Text dataType, Text variableName) {
        this(dataType, variableName);
        this.setGenericType(genericType);
    }

    public Text getGenericType() {
        return this.genericType;
    }

    public Text getDataType() {
        return this.dataType;
    }

    public Text getVariableName() {
        return this.variableName;
    }

    public IoModelGroup getParent() {
        return this.parent;
    }

    public boolean isPrimitive() {
        if (this instanceof IoModelPrimitive) {
            return true;
        }
        if (this instanceof IoModelArray) {
            return this.isDataTypePrimitive(this.getDataType());
        }
        return false;
    }

    private boolean isDataTypePrimitive(Text dataType) {
        try {
            ModelPrimitiveType.valueOf(dataType.getUpperCase());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setGenericType(Text genericType) {
        this.genericType = genericType;
    }

    private void setDataType(Text dataType) {
        this.dataType = dataType;
    }

    private void setVariableName(Text variableName) {
        this.variableName = variableName;
    }

    private void setParent(IoModelGroup parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoModel ioModel = (IoModel)o;
        return new EqualsBuilder().append((Object)this.genericType, (Object)ioModel.genericType).append((Object)this.dataType, (Object)ioModel.dataType).append((Object)this.variableName, (Object)ioModel.variableName).append((Object)this.parent, (Object)ioModel.parent).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.genericType).append((Object)this.dataType).append((Object)this.variableName).append((Object)this.parent).toHashCode();
    }
}

