/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.system.model.core;

import io.polygenesis.shared.valueobject.Text;
import io.polygenesis.system.model.core.Function;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Thing {
    private Text name;
    private Thing parent;
    private Set<Function> functions;

    public Thing(Text thingName) {
        this.setName(thingName);
        this.setFunctions(new LinkedHashSet<Function>());
    }

    public Thing(Text thingName, Thing parentThing) {
        this.setName(thingName);
        this.setParent(parentThing);
        this.setFunctions(new LinkedHashSet<Function>());
    }

    void appendFunction(Function function) {
        this.functions.add(function);
    }

    void appendFunctions(Set<Function> functions) {
        this.functions.addAll(functions);
    }

    public Text getName() {
        return this.name;
    }

    public Thing getParent() {
        return this.parent;
    }

    Set<Function> getFunctions() {
        return this.functions;
    }

    private void setName(Text name) {
        this.name = name;
    }

    private void setParent(Thing parent) {
        this.parent = parent;
    }

    private void setFunctions(Set<Function> functions) {
        this.functions = functions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Thing thing = (Thing)o;
        return new EqualsBuilder().append((Object)this.name, (Object)thing.name).append((Object)this.parent, (Object)thing.parent).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.parent).toHashCode();
    }
}

