/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.system.model.core;

import io.polygenesis.shared.valueobject.Text;
import io.polygenesis.system.model.ModelRepository;
import io.polygenesis.system.model.core.Function;
import io.polygenesis.system.model.core.Thing;
import java.util.Optional;
import java.util.Set;

public class CoreModelRepository
implements ModelRepository {
    private Set<Thing> things;

    public CoreModelRepository(Set<Thing> things) {
        this.setThings(things);
    }

    public Optional<Thing> getThingByName(Text thingName) {
        return this.things.stream().filter(thing -> thing.getName().equals((Object)thingName)).findFirst();
    }

    public Optional<Function> getThingFunction(Text thingName, Text functionName) {
        Optional<Thing> optionalThing = this.getThingByName(thingName);
        return optionalThing.flatMap(thing -> thing.getFunctions().stream().filter(function -> function.getName().equals((Object)functionName)).findFirst());
    }

    public Set<Thing> getThings() {
        return this.things;
    }

    private void setThings(Set<Thing> things) {
        this.things = things;
    }
}

