/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.sql;

import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.core.AbstractMetamodelGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.sql.ScriptExporter;
import io.polygenesis.models.sql.SqlTableMetamodelRepository;
import java.nio.file.Path;
import java.util.Set;

public class SqlMetamodelGenerator
extends AbstractMetamodelGenerator {
    private final ContextName contextName;
    private final ScriptExporter scriptExporter;
    private final String tablePrefix;

    public SqlMetamodelGenerator(Path generationPath, ContextName contextName, ScriptExporter scriptExporter, String tablePrefix) {
        super(generationPath);
        this.contextName = contextName;
        this.scriptExporter = scriptExporter;
        this.tablePrefix = tablePrefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public ContextName getContextName() {
        return this.contextName;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        SqlTableMetamodelRepository sqlTableModelRepository = (SqlTableMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, SqlTableMetamodelRepository.class);
        this.scriptExporter.export(this.getGenerationPath(), sqlTableModelRepository, this.getTablePrefix(), this.getContextName().getText());
    }
}

