/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.sql;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.models.sql.SqlTableMetamodelRepository;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class ScriptExporter {
    private static Integer counter = 0;
    private final FreemarkerService freemarkerService;

    public ScriptExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void export(Path generationPath, SqlTableMetamodelRepository sqlTableModelRepository, String tablePrefix, String context) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("representation", sqlTableModelRepository);
        dataModel.put("tablePrefix", tablePrefix);
        this.freemarkerService.export(dataModel, "polygenesis-generator-java-sql-flyway/script.sql.ftl", this.makeFileName(generationPath, context));
    }

    private Path makeFileName(Path generationPath, String context) {
        counter = counter + 1;
        String name = String.format("V%s__%s__Initialize", counter, context);
        return Paths.get(generationPath.toString(), "src/main/resources/db/migration", name + ".sql.txt");
    }
}

