/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.spreadsheet;

import io.polygenesis.core.Transformer;
import io.polygenesis.metamodels.spreadsheet.Cell;
import io.polygenesis.metamodels.spreadsheet.Sheet;
import io.polygenesis.metamodels.spreadsheet.Spreadsheet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SpreadsheetTransformer
implements Transformer<Spreadsheet> {
    public ByteArrayOutputStream transform(Spreadsheet source) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            source.getSheets().forEach(sheet -> this.createXssfSheet(workbook, (Sheet)sheet));
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return byteArrayOutputStream;
    }

    private XSSFSheet createXssfSheet(XSSFWorkbook workbook, Sheet sheet) {
        XSSFSheet xssfSheet = workbook.createSheet(sheet.getName().getText());
        IntStream.range(0, sheet.getNumberOfRows()).forEach(rowIndex -> {
            XSSFRow row = xssfSheet.createRow(rowIndex);
            sheet.getCellsByRowIndex(Integer.valueOf(rowIndex)).stream().forEach(arg_0 -> SpreadsheetTransformer.lambda$createXssfSheet$1((Row)row, arg_0));
        });
        return xssfSheet;
    }

    private static /* synthetic */ void lambda$createXssfSheet$1(Row row, Cell sheetCell) {
        org.apache.poi.ss.usermodel.Cell cell = row.createCell(sheetCell.getColumnIndex().getIndex().intValue());
        cell.setCellValue(sheetCell.getValue().getValue().toString());
    }
}

