/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.spreadsheet;

import io.polygenesis.core.AbstractMetamodelGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.spreadsheet.SpreadsheetGenerator;
import io.polygenesis.metamodels.spreadsheet.Spreadsheet;
import io.polygenesis.metamodels.spreadsheet.SpreadsheetMetamodelRepository;
import java.nio.file.Path;
import java.util.Set;

public class SpreadsheetMetamodelGenerator
extends AbstractMetamodelGenerator {
    private static final String SPREADSHEET_POSTFIX = "xlsx";
    private final SpreadsheetGenerator spreadsheetGenerator;

    public SpreadsheetMetamodelGenerator(Path generationPath, SpreadsheetGenerator spreadsheetGenerator) {
        super(generationPath);
        this.spreadsheetGenerator = spreadsheetGenerator;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        ((SpreadsheetMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, SpreadsheetMetamodelRepository.class)).getItems().forEach(spreadsheet -> this.spreadsheetGenerator.generate((Generatable)spreadsheet, this.serviceExportInfo(this.getGenerationPath(), (Spreadsheet)spreadsheet), new Object[0]));
    }

    private ExportInfo serviceExportInfo(Path generationPath, Spreadsheet spreadsheet) {
        return ExportInfo.file((Path)generationPath, (String)String.format("%s.%s", spreadsheet.getObjectName().getText(), SPREADSHEET_POSTFIX));
    }
}

