/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.flutter.project.app;

import io.polygenesis.abstraction.thing.Function;
import io.polygenesis.abstraction.thing.FunctionProvider;
import io.polygenesis.core.DataTypeTransformer;
import io.polygenesis.core.Nameable;
import io.polygenesis.core.Project;
import io.polygenesis.core.TemplateData;
import io.polygenesis.generators.flutter.project.FlutterProjectDataExtractor;
import io.polygenesis.generators.flutter.project.app.FlutterAppMethodTransformer;
import io.polygenesis.generators.java.shared.transformer.MethodTransformer;
import io.polygenesis.metamodels.appflutter.FlutterApp;
import io.polygenesis.representations.code.ClassRepresentation;
import io.polygenesis.representations.code.ConstructorRepresentation;
import io.polygenesis.representations.code.FieldRepresentation;
import io.polygenesis.representations.code.MethodRepresentation;
import io.polygenesis.transformers.dart.AbstractDartClassTransformer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FlutterAppTransformer
extends AbstractDartClassTransformer<FlutterApp, Function> {
    private final FlutterProjectDataExtractor flutterProjectDataExtractor;

    public FlutterAppTransformer(DataTypeTransformer dataTypeTransformer, FlutterAppMethodTransformer methodTransformer, FlutterProjectDataExtractor flutterProjectDataExtractor) {
        super(dataTypeTransformer, (MethodTransformer)methodTransformer);
        this.flutterProjectDataExtractor = flutterProjectDataExtractor;
    }

    public TemplateData transform(FlutterApp source, Object ... args) {
        HashMap<String, ClassRepresentation> dataModel = new HashMap<String, ClassRepresentation>();
        dataModel.put("data", this.create((Nameable)source, args));
        return new TemplateData(dataModel, "polygenesis-dart/Class.dart.ftl");
    }

    public Set<FieldRepresentation> staticFieldRepresentations(FlutterApp source, Object ... args) {
        return new LinkedHashSet<FieldRepresentation>();
    }

    public Set<FieldRepresentation> stateFieldRepresentations(FlutterApp source, Object ... args) {
        return super.stateFieldRepresentations((Nameable)source, args);
    }

    public Set<ConstructorRepresentation> constructorRepresentations(FlutterApp source, Object ... args) {
        return super.constructorRepresentations((Nameable)source, args);
    }

    public Set<MethodRepresentation> methodRepresentations(FlutterApp source, Object ... args) {
        return source.getFunctions().stream().map(method -> this.methodTransformer.create((FunctionProvider)method, args)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String packageName(FlutterApp source, Object ... args) {
        return super.packageName((Nameable)source, args);
    }

    public Set<String> imports(FlutterApp source, Object ... args) {
        Project project = (Project)args[0];
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("package:flutter/material.dart");
        imports.add("package:provider/provider.dart");
        this.flutterProjectDataExtractor.screens(project).forEach(screen -> imports.add(screen.toString()));
        return imports;
    }

    public Set<String> annotations(FlutterApp source, Object ... args) {
        return super.annotations((Nameable)source, args);
    }

    public String description(FlutterApp source, Object ... args) {
        return super.description((Nameable)source, args);
    }

    public String modifiers(FlutterApp source, Object ... args) {
        return "";
    }

    public String simpleObjectName(FlutterApp source, Object ... args) {
        return super.simpleObjectName((Nameable)source, args);
    }

    public String fullObjectName(FlutterApp source, Object ... args) {
        return String.format("%s extends StatelessWidget", this.simpleObjectName(source, args));
    }
}

