/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.flutter.context.model;

import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.AbstractMetamodelGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.flutter.context.model.dto.ModelGenerator;
import io.polygenesis.models.api.Dto;
import io.polygenesis.models.api.Service;
import io.polygenesis.models.api.ServiceMetamodelRepository;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class ModelMetamodelGenerator
extends AbstractMetamodelGenerator {
    private final PackageName rootPackageName;
    private final ContextName contextName;
    private final ModelGenerator modelGenerator;

    public ModelMetamodelGenerator(Path generationPath, PackageName rootPackageName, ContextName contextName, ModelGenerator modelGenerator) {
        super(generationPath);
        this.rootPackageName = rootPackageName;
        this.contextName = contextName;
        this.modelGenerator = modelGenerator;
    }

    public PackageName getRootPackageName() {
        return this.rootPackageName;
    }

    public ContextName getContextName() {
        return this.contextName;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        ((ServiceMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, ServiceMetamodelRepository.class)).getItems().forEach(service -> service.getDtos().forEach(dto -> {
            if (!dto.getVirtual().booleanValue()) {
                this.modelGenerator.generate((Generatable)dto, this.modelExportInfo(this.getGenerationPath(), (Dto)dto, (Service)service), new Object[0]);
            }
        }));
    }

    private ExportInfo modelExportInfo(Path generationPath, Dto dto, Service service) {
        return ExportInfo.file((Path)Paths.get(generationPath.toString(), TextConverter.toLowerUnderscore((String)service.getThingName().getText()), "models"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)dto.getDataObject().getObjectName().getText()), ".dart"));
    }
}

