/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.flutter.context;

import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.MetamodelGenerator;
import io.polygenesis.generators.flutter.context.FlutterContextGenerator;
import io.polygenesis.generators.flutter.context.model.ModelMetamodelGenerator;
import io.polygenesis.generators.flutter.context.model.ModelMetamodelGeneratorFactory;
import io.polygenesis.generators.flutter.context.provider.ProviderMetamodelGenerator;
import io.polygenesis.generators.flutter.context.provider.ProviderMetamodelGeneratorFactory;
import io.polygenesis.generators.flutter.context.ui.UiMetamodelGenerator;
import io.polygenesis.generators.flutter.context.ui.UiMetamodelGeneratorFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;

public class FlutterContextGeneratorFactory {
    private FlutterContextGeneratorFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static FlutterContextGenerator newInstance(Path generationPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        LinkedHashSet<MetamodelGenerator> metamodelGenerators = new LinkedHashSet<MetamodelGenerator>();
        metamodelGenerators.add((MetamodelGenerator)FlutterContextGeneratorFactory.modelMetamodelGenerator(generationPath.toString(), contextFolder, rootPackageName, contextName));
        metamodelGenerators.add((MetamodelGenerator)FlutterContextGeneratorFactory.providerMetamodelGenerator(generationPath.toString(), contextFolder, rootPackageName, contextName));
        metamodelGenerators.add((MetamodelGenerator)FlutterContextGeneratorFactory.uiMetamodelGenerator(generationPath.toString(), contextFolder, rootPackageName, contextName));
        return new FlutterContextGenerator(generationPath, metamodelGenerators);
    }

    private static ModelMetamodelGenerator modelMetamodelGenerator(String exportPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        return ModelMetamodelGeneratorFactory.newInstance(Paths.get(exportPath, "lib", contextFolder), rootPackageName, contextName);
    }

    private static ProviderMetamodelGenerator providerMetamodelGenerator(String exportPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        return ProviderMetamodelGeneratorFactory.newInstance(Paths.get(exportPath, "lib", contextFolder), rootPackageName, contextName);
    }

    private static UiMetamodelGenerator uiMetamodelGenerator(String exportPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        return UiMetamodelGeneratorFactory.newInstance(Paths.get(exportPath, "lib", contextFolder), rootPackageName, contextName);
    }
}

