/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.flutter.context.provider;

import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.AbstractMetamodelGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.flutter.context.provider.collection.ProviderCollectionGenerator;
import io.polygenesis.generators.flutter.context.provider.detail.ProviderDetailGenerator;
import io.polygenesis.metamodels.stateprovider.Provider;
import io.polygenesis.metamodels.stateprovider.ProviderMetamodelRepository;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class ProviderMetamodelGenerator
extends AbstractMetamodelGenerator {
    private final PackageName rootPackageName;
    private final ContextName contextName;
    private final ProviderCollectionGenerator providerCollectionGenerator;
    private final ProviderDetailGenerator providerDetailGenerator;

    public ProviderMetamodelGenerator(Path generationPath, PackageName rootPackageName, ContextName contextName, ProviderCollectionGenerator providerCollectionGenerator, ProviderDetailGenerator providerDetailGenerator) {
        super(generationPath);
        this.rootPackageName = rootPackageName;
        this.contextName = contextName;
        this.providerCollectionGenerator = providerCollectionGenerator;
        this.providerDetailGenerator = providerDetailGenerator;
    }

    public PackageName getRootPackageName() {
        return this.rootPackageName;
    }

    public ContextName getContextName() {
        return this.contextName;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        ((ProviderMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, ProviderMetamodelRepository.class)).getItems().forEach(provider -> {
            switch (provider.getProviderType()) {
                case DETAIL: {
                    this.providerDetailGenerator.generate((Generatable)provider, this.providerExportInfo(this.getGenerationPath(), (Provider)provider), new Object[0]);
                    break;
                }
                case COLLECTION: {
                    this.providerCollectionGenerator.generate((Generatable)provider, this.providerExportInfo(this.getGenerationPath(), (Provider)provider), new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown provider type=%s", provider.getProviderType()));
                }
            }
        });
    }

    private ExportInfo providerExportInfo(Path generationPath, Provider provider) {
        return ExportInfo.file((Path)Paths.get(generationPath.toString(), TextConverter.toLowerUnderscore((String)provider.getFeatureName().getText()), "providers"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)provider.getName().getText()), ".dart"));
    }
}

