/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.skeletons;

import io.polygenesis.abstraction.data.Data;
import io.polygenesis.abstraction.data.PrimitiveType;
import io.polygenesis.commons.text.TextConverter;
import java.util.EnumMap;
import java.util.stream.Stream;

public class FromDataTypeToTypescriptConverter {
    private static EnumMap<PrimitiveType, String> dataTypeMap;

    public String getDeclaredVariableType(Data model) {
        String candidate = TextConverter.toUpperCamel((String)model.getDataType());
        return Stream.of(PrimitiveType.values()).filter(value -> value.name().equalsIgnoreCase(candidate)).findFirst().map(primaryType -> dataTypeMap.get(primaryType)).orElseGet(() -> candidate);
    }

    private static void initialize() {
        dataTypeMap = new EnumMap(PrimitiveType.class);
        dataTypeMap.put(PrimitiveType.VOID, "void");
        dataTypeMap.put(PrimitiveType.STRING, "string");
        dataTypeMap.put(PrimitiveType.INTEGER, "number");
        dataTypeMap.put(PrimitiveType.LONG, "number");
        dataTypeMap.put(PrimitiveType.BOOLEAN, "boolean");
    }

    public String getModifierPrivate() {
        return "private";
    }

    static {
        FromDataTypeToTypescriptConverter.initialize();
    }
}

