/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.ui.container;

import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerFolderType;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerHtmlExporter;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerScssExporter;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerTypescriptExporter;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerTypescriptSpecExporter;
import io.polygenesis.models.ui.Feature;
import io.polygenesis.models.ui.container.AbstractContainer;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UiContainerExporter {
    private final UiContainerHtmlExporter uiContainerHtmlExporter;
    private final UiContainerScssExporter uiContainerScssExporter;
    private final UiContainerTypescriptExporter uiContainerTypescriptExporter;
    private final UiContainerTypescriptSpecExporter uiContainerTypescriptSpecExporter;

    public UiContainerExporter(UiContainerHtmlExporter uiContainerHtmlExporter, UiContainerScssExporter uiContainerScssExporter, UiContainerTypescriptExporter uiContainerTypescriptExporter, UiContainerTypescriptSpecExporter uiContainerTypescriptSpecExporter) {
        this.uiContainerHtmlExporter = uiContainerHtmlExporter;
        this.uiContainerScssExporter = uiContainerScssExporter;
        this.uiContainerTypescriptExporter = uiContainerTypescriptExporter;
        this.uiContainerTypescriptSpecExporter = uiContainerTypescriptSpecExporter;
    }

    public void exportFeatureContainer(Path generationPathApp, Feature feature, AbstractContainer container) {
        Path contextFeaturePath = Paths.get(TextConverter.toLowerHyphen((String)feature.getContextName().getText()), TextConverter.toLowerHyphen((String)feature.getFeatureName().getText()));
        this.uiContainerHtmlExporter.exportHtml(generationPathApp, contextFeaturePath, container, UiContainerFolderType.PAGE);
        this.uiContainerScssExporter.exportScss(generationPathApp, contextFeaturePath, container, UiContainerFolderType.PAGE);
        this.uiContainerTypescriptExporter.exportTypescript(generationPathApp, contextFeaturePath, container, UiContainerFolderType.PAGE);
        this.uiContainerTypescriptSpecExporter.exportTypescriptSpec(generationPathApp, contextFeaturePath, container, UiContainerFolderType.PAGE);
    }

    public void exportComponentContainer(Path generationPathApp, Path contextFeaturePath, AbstractContainer container) {
        this.uiContainerHtmlExporter.exportHtml(generationPathApp, contextFeaturePath, container, UiContainerFolderType.COMPONENT);
        this.uiContainerScssExporter.exportScss(generationPathApp, contextFeaturePath, container, UiContainerFolderType.COMPONENT);
        this.uiContainerTypescriptExporter.exportTypescript(generationPathApp, contextFeaturePath, container, UiContainerFolderType.COMPONENT);
        this.uiContainerTypescriptSpecExporter.exportTypescriptSpec(generationPathApp, contextFeaturePath, container, UiContainerFolderType.COMPONENT);
    }

    public void exportLayoutContainer(Path generationPathApp, Path contextFeaturePath, AbstractContainer container) {
        this.uiContainerHtmlExporter.exportHtml(generationPathApp, contextFeaturePath, container, UiContainerFolderType.LAYOUT);
        this.uiContainerScssExporter.exportScss(generationPathApp, contextFeaturePath, container, UiContainerFolderType.LAYOUT);
        this.uiContainerTypescriptExporter.exportTypescript(generationPathApp, contextFeaturePath, container, UiContainerFolderType.LAYOUT);
        this.uiContainerTypescriptSpecExporter.exportTypescriptSpec(generationPathApp, contextFeaturePath, container, UiContainerFolderType.LAYOUT);
    }
}

