/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.ui;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.models.ui.Feature;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class UiModuleExporter {
    private final FreemarkerService freemarkerService;

    public UiModuleExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void exportModule(Path generationPathApp, Feature feature, Map<String, Object> dataModel) {
        Path contextFeaturePath = Paths.get(TextConverter.toLowerHyphen((String)feature.getContextName().getText()), TextConverter.toLowerHyphen((String)feature.getFeatureName().getText()));
        Path modulePath = Paths.get(generationPathApp.toString(), contextFeaturePath.toString());
        PathService.ensurePath((Path)modulePath);
        this.freemarkerService.export(dataModel, "polygenesis-angular-generator/ui/default/module/index.ftl", Paths.get(modulePath.toString(), this.makeModuleFileName(feature)));
    }

    private String makeModuleFileName(Feature feature) {
        return TextConverter.toLowerHyphen((String)feature.getFeatureName().getText()) + ".module.ts";
    }
}

