/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate.model;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.model.ModelRepresentable;
import io.polygenesis.generators.angular.legacy.skeletons.model.ModelRepresentation;
import io.polygenesis.metamodels.stateredux.Model;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class ModelExporter {
    private static final String FREEMARKER_TEMPLATE_MODEL = "polygenesis-representation-typescript/ngrx/models/model.ts.ftl";
    private final FreemarkerService freemarkerService;
    private final ModelRepresentable modelRepresentable;

    public ModelExporter(FreemarkerService freemarkerService, ModelRepresentable modelRepresentable) {
        this.freemarkerService = freemarkerService;
        this.modelRepresentable = modelRepresentable;
    }

    public void exportModels(Path modelsPath, Model model) {
        HashMap<String, ModelRepresentation> dataModel = new HashMap<String, ModelRepresentation>();
        dataModel.put("representation", this.modelRepresentable.create(model));
        this.freemarkerService.export(dataModel, FREEMARKER_TEMPLATE_MODEL, Paths.get(modelsPath.toString(), this.makeModelFileName(model)));
    }

    private String makeModelFileName(Model model) {
        return String.format("%s.%s", TextConverter.toLowerHyphen((String)model.getData().getDataType()), "model.ts");
    }
}

