/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate.action;

import io.polygenesis.commons.keyvalue.KeyValue;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.FeatureName;
import io.polygenesis.generators.angular.legacy.skeletons.FromDataTypeToTypescriptConverter;
import io.polygenesis.generators.angular.legacy.skeletons.action.ActionClass;
import io.polygenesis.generators.angular.legacy.skeletons.action.ActionEnumeration;
import io.polygenesis.generators.angular.legacy.skeletons.action.ActionGroupRepresentation;
import io.polygenesis.generators.angular.legacy.skeletons.action.ActionUnion;
import io.polygenesis.metamodels.stateredux.ActionGroup;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ActionGroupRepresentable {
    private final FromDataTypeToTypescriptConverter fromDataTypeToTypescriptConverter;

    public ActionGroupRepresentable(FromDataTypeToTypescriptConverter fromDataTypeToTypescriptConverter) {
        this.fromDataTypeToTypescriptConverter = fromDataTypeToTypescriptConverter;
    }

    public ActionGroupRepresentation create(FeatureName featureName, ActionGroup actionGroup) {
        return new ActionGroupRepresentation(this.importObjects(actionGroup), this.actionEnumeration(featureName, actionGroup), this.actionClasses(featureName, actionGroup), this.actionUnion(featureName, actionGroup));
    }

    private Map<Set<String>, String> importObjects(ActionGroup actionGroup) {
        LinkedHashMap<Set<String>, String> importObjects = new LinkedHashMap<Set<String>, String>();
        importObjects.put(new LinkedHashSet<String>(Arrays.asList("Action")), "@ngrx/store");
        actionGroup.getActions().forEach(action -> {
            if (action.getPayloadModel().getData().isDataGroup()) {
                importObjects.put(new LinkedHashSet<String>(Arrays.asList(TextConverter.toUpperCamel((String)action.getPayloadModel().getData().getDataType()))), String.format("../models/%s.model", TextConverter.toLowerHyphen((String)action.getPayloadModel().getData().getDataType())));
            }
        });
        return importObjects;
    }

    private ActionEnumeration actionEnumeration(FeatureName featureName, ActionGroup actionGroup) {
        return new ActionEnumeration(this.getEnumerationName(featureName), this.getEnumerationKeyValues(featureName, actionGroup));
    }

    private Set<ActionClass> actionClasses(FeatureName featureName, ActionGroup actionGroup) {
        LinkedHashSet<ActionClass> actionClasses = new LinkedHashSet<ActionClass>();
        actionGroup.getActions().forEach(action -> actionClasses.add(new ActionClass(TextConverter.toUpperCamel((String)action.getName().getText()), String.format("%s.%s", this.getEnumerationName(featureName), TextConverter.toUpperCamel((String)action.getName().getText())), this.fromDataTypeToTypescriptConverter.getDeclaredVariableType(action.getPayloadModel().getData()))));
        return actionClasses;
    }

    private ActionUnion actionUnion(FeatureName featureName, ActionGroup actionGroup) {
        return new ActionUnion(String.format("%sApiActionsUnion", TextConverter.toUpperCamel((String)featureName.getText())), this.getEnumerationKeyValues(featureName, actionGroup));
    }

    private String getEnumerationName(FeatureName featureName) {
        return String.format("%sApiActionTypes", TextConverter.toUpperCamel((String)featureName.getText()));
    }

    private Set<KeyValue> getEnumerationKeyValues(FeatureName featureName, ActionGroup actionGroup) {
        LinkedHashSet<KeyValue> keyValues = new LinkedHashSet<KeyValue>();
        actionGroup.getActions().forEach(action -> {
            String text = String.format("%s", TextConverter.toUpperCamel((String)action.getName().getText()));
            keyValues.add(new KeyValue((Object)TextConverter.toUpperCamel((String)text), (Object)String.format("[%s] %s", TextConverter.toUpperCamelSpaces((String)featureName.getText()), TextConverter.toUpperCamelSpaces((String)text))));
        });
        return keyValues;
    }
}

