/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate.action;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.FeatureName;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.action.ActionGroupRepresentable;
import io.polygenesis.generators.angular.legacy.skeletons.action.ActionGroupRepresentation;
import io.polygenesis.metamodels.stateredux.ActionGroup;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class ActionGroupExporter {
    private static final String FREEMARKER_ACTION_GROUP = "polygenesis-representation-typescript/ngrx/actions/action-group.ts.ftl";
    private final FreemarkerService freemarkerService;
    private final ActionGroupRepresentable actionGroupRepresentable;

    public ActionGroupExporter(FreemarkerService freemarkerService, ActionGroupRepresentable actionGroupRepresentable) {
        this.freemarkerService = freemarkerService;
        this.actionGroupRepresentable = actionGroupRepresentable;
    }

    public void exportActionGroup(Path actionsGenerationPath, FeatureName featureName, ActionGroup actionGroup) {
        HashMap<String, ActionGroupRepresentation> dataModel = new HashMap<String, ActionGroupRepresentation>();
        dataModel.put("representation", this.actionGroupRepresentable.create(featureName, actionGroup));
        this.freemarkerService.export(dataModel, FREEMARKER_ACTION_GROUP, Paths.get(actionsGenerationPath.toString(), this.makeActionsFileName(actionGroup)));
    }

    private String makeActionsFileName(ActionGroup actionGroup) {
        return String.format("%s.%s", TextConverter.toLowerHyphen((String)actionGroup.getActionGroupName().getText()), "actions.ts");
    }
}

