/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate;

import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.EffectExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.IndexReducerExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.ModuleExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.ReducerExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.ServiceExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.action.ActionGroupExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.action.ActionIndexExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.model.ModelExporter;
import io.polygenesis.metamodels.stateredux.ActionGroup;
import io.polygenesis.metamodels.stateredux.Model;
import io.polygenesis.metamodels.stateredux.Store;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class StoreExporter {
    private ActionGroupExporter actionGroupExporter;
    private ActionIndexExporter actionIndexExporter;
    private ReducerExporter reducerExporter;
    private IndexReducerExporter indexReducerExporter;
    private EffectExporter effectExporter;
    private ServiceExporter serviceExporter;
    private ModelExporter modelExporter;
    private ModuleExporter moduleExporter;

    public StoreExporter(ActionGroupExporter actionGroupExporter, ActionIndexExporter actionIndexExporter, ReducerExporter reducerExporter, IndexReducerExporter indexReducerExporter, EffectExporter effectExporter, ServiceExporter serviceExporter, ModelExporter modelExporter, ModuleExporter moduleExporter) {
        this.actionGroupExporter = actionGroupExporter;
        this.actionIndexExporter = actionIndexExporter;
        this.reducerExporter = reducerExporter;
        this.indexReducerExporter = indexReducerExporter;
        this.effectExporter = effectExporter;
        this.serviceExporter = serviceExporter;
        this.modelExporter = modelExporter;
        this.moduleExporter = moduleExporter;
    }

    public void export(Path generationPathApp, Store store) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("store", store);
        Path actionsGenerationPath = Paths.get(generationPathApp.toString(), "ngrx", TextConverter.toLowerHyphen((String)store.getFeatureName().getText()), "actions");
        PathService.ensurePath((Path)actionsGenerationPath);
        store.getActionGroups().forEach(actionGroup -> this.actionGroupExporter.exportActionGroup(actionsGenerationPath, store.getFeatureName(), (ActionGroup)actionGroup));
        this.actionIndexExporter.exportActionIndex(actionsGenerationPath, store.getActionGroups());
        this.reducerExporter.exportReducers(generationPathApp, store, dataModel);
        this.indexReducerExporter.exportIndexReducer(generationPathApp, store, dataModel);
        this.effectExporter.exportEffects(generationPathApp, store, dataModel);
        this.serviceExporter.exportService(generationPathApp, store, dataModel);
        Path modelsPath = Paths.get(generationPathApp.toString(), "ngrx", TextConverter.toLowerHyphen((String)store.getFeatureName().getText()), "models");
        PathService.ensurePath((Path)modelsPath);
        store.getModels().forEach(model -> {
            if (!model.getData().isDataGroup()) {
                throw new IllegalArgumentException();
            }
            this.modelExporter.exportModels(modelsPath, (Model)model);
        });
        this.moduleExporter.exportModule(generationPathApp, store, dataModel);
    }
}

