/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.metamodels.stateredux.Store;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class ReducerExporter {
    private final FreemarkerService freemarkerService;

    public ReducerExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void exportReducers(Path generationPath, Store store, Map<String, Object> dataModel) {
        Path reducersPath = Paths.get(generationPath.toString(), "ngrx", TextConverter.toLowerHyphen((String)store.getFeatureName().getText()), "reducers");
        PathService.ensurePath((Path)reducersPath);
        this.freemarkerService.export(dataModel, "polygenesis-angular-generator/ngrx/analytical/reducer/index.ftl", Paths.get(reducersPath.toString(), this.makeReducersFileName(store)));
    }

    private String makeReducersFileName(Store store) {
        return TextConverter.toLowerHyphen((String)store.getFeatureName().getText()) + ".reducers.ts";
    }
}

