/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.metamodels.stateredux.Store;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class ModuleExporter {
    private final FreemarkerService freemarkerService;

    public ModuleExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void exportModule(Path generationPath, Store store, Map<String, Object> dataModel) {
        Path modulePath = Paths.get(generationPath.toString(), "ngrx", TextConverter.toLowerHyphen((String)store.getFeatureName().getText()));
        PathService.ensurePath((Path)modulePath);
        this.freemarkerService.export(dataModel, "polygenesis-angular-generator/ngrx/shared/module/index.ftl", Paths.get(modulePath.toString(), this.makeModuleFileName(store)));
    }

    private String makeModuleFileName(Store store) {
        return TextConverter.toLowerHyphen((String)store.getFeatureName().getText()) + ".module.ts";
    }
}

