/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.reactivestate;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.metamodels.stateredux.Store;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class EffectExporter {
    private final FreemarkerService freemarkerService;

    public EffectExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void exportEffects(Path generationPath, Store store, Map<String, Object> dataModel) {
        Path effectsPath = Paths.get(generationPath.toString(), "ngrx", TextConverter.toLowerHyphen((String)store.getFeatureName().getText()), "effects");
        PathService.ensurePath((Path)effectsPath);
        this.freemarkerService.export(dataModel, "polygenesis-angular-generator/ngrx/shared/effect/index.ftl", Paths.get(effectsPath.toString(), this.makeEffectsFileName(store)));
    }

    private String makeEffectsFileName(Store store) {
        return TextConverter.toLowerHyphen((String)store.getFeatureName().getText()) + ".effects.ts";
    }
}

