/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.once;

import io.polygenesis.commons.freemarker.FreemarkerService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class OnceSourceRootExporter {
    private static final String FTL_INDEX_HTML = "polygenesis-angular-generator/src/index.html.ftl";
    private static final String FTL_STYLES_SCSS = "polygenesis-angular-generator/src/styles.scss.ftl";
    private static final String FTL_MAIN_TS = "polygenesis-angular-generator/src/main.ts.ftl";
    private static final String FILE_INDEX_HTML = "index.html";
    private static final String FILE_STYLES_SCSS = "styles.scss";
    private static final String FILE_MAIN_TS = "main.ts";
    private final FreemarkerService freemarkerService;

    public OnceSourceRootExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void export(Path generationPath) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        this.exportIndexHtml(generationPath, dataModel);
        this.exportStylesScss(generationPath, dataModel);
        this.exportMainTs(generationPath, dataModel);
    }

    private void exportIndexHtml(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_INDEX_HTML, Paths.get(generationPath.toString(), FILE_INDEX_HTML));
    }

    private void exportStylesScss(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_STYLES_SCSS, Paths.get(generationPath.toString(), FILE_STYLES_SCSS));
    }

    private void exportMainTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_MAIN_TS, Paths.get(generationPath.toString(), FILE_MAIN_TS));
    }
}

