/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.once;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.generators.angular.legacy.exporters.ui.container.UiContainerExporter;
import io.polygenesis.models.ui.UiLayoutContainerMetamodelRepository;
import io.polygenesis.models.ui.container.AbstractContainer;
import io.polygenesis.models.ui.container.AbstractContainerWithElements;
import io.polygenesis.models.ui.container.LayoutContainer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class OnceSharedModuleExporter {
    private static final String FTL_APP_SHARED_MODULE_TS = "polygenesis-angular-generator/src/app/shared/shared.module.ts.ftl";
    private static final String SHARED_MODULE_FOLDER = "shared";
    private static final String FILE_APP_SHARED_MODULE_TS = "shared/shared.module.ts";
    private final FreemarkerService freemarkerService;
    private final UiContainerExporter uiContainerExporter;

    public OnceSharedModuleExporter(FreemarkerService freemarkerService, UiContainerExporter uiContainerExporter) {
        this.freemarkerService = freemarkerService;
        this.uiContainerExporter = uiContainerExporter;
    }

    public void export(Path generationPath, UiLayoutContainerMetamodelRepository uiLayoutContainerModelRepository) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("layouts", uiLayoutContainerModelRepository.getItems());
        this.exportSharedModuleTs(generationPath, dataModel);
        uiLayoutContainerModelRepository.getItems().forEach(layoutContainer -> this.exportLayout(generationPath, (LayoutContainer)layoutContainer));
    }

    private void exportSharedModuleTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_SHARED_MODULE_TS, Paths.get(generationPath.toString(), FILE_APP_SHARED_MODULE_TS));
    }

    private void exportLayout(Path generationPath, LayoutContainer layout) {
        HashMap<String, LayoutContainer> dataModel = new HashMap<String, LayoutContainer>();
        dataModel.put("layout", layout);
        this.uiContainerExporter.exportLayoutContainer(generationPath, Paths.get(SHARED_MODULE_FOLDER, new String[0]), (AbstractContainer)layout);
        this.exportComponentsFromLayout(generationPath, (AbstractContainerWithElements)layout.getTop());
    }

    private void exportComponentsFromLayout(Path generationPath, AbstractContainerWithElements container) {
        if (container == null) {
            return;
        }
        if (container.getElementGroup() == null) {
            return;
        }
        this.uiContainerExporter.exportComponentContainer(generationPath, Paths.get(SHARED_MODULE_FOLDER, new String[0]), (AbstractContainer)container);
    }
}

