/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.once;

import io.polygenesis.commons.freemarker.FreemarkerService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class OnceLandingModuleExporter {
    private static final String FTL_LANDING_CONTAINER = "polygenesis-angular-generator/src/app/landing/containers/landing-container";
    private static final String FTL_LANDING_MODULE_TS = "polygenesis-angular-generator/src/app/landing/landing.module.ts.ftl";
    private static final String FTL_LANDING_ROUTING_MODULE_TS = "polygenesis-angular-generator/src/app/landing/landing-routing.module.ts.ftl";
    private static final String FTL_LANDING_COMPONENT_HTML = "polygenesis-angular-generator/src/app/landing/containers/landing-container/landing-container.component.html.ftl";
    private static final String FTL_LANDING_COMPONENT_SCSS = "polygenesis-angular-generator/src/app/landing/containers/landing-container/landing-container.component.scss.ftl";
    private static final String FTL_LANDING_COMPONENT_TS = "polygenesis-angular-generator/src/app/landing/containers/landing-container/landing-container.component.ts.ftl";
    private static final String FTL_LANDING_COMPONENT_SPEC_TS = "polygenesis-angular-generator/src/app/landing/containers/landing-container/landing-container.component.spec.ts.ftl";
    private static final String FILE_LANDING_MODULE_TS = "landing/landing.module.ts";
    private static final String FILE_LANDING_ROUTING_MODULE_TS = "landing/landing-routing.module.ts";
    private static final String FILE_LANDING_COMPONENT_HTML = "landing/containers/landing-container/landing-container.component.html";
    private static final String FILE_LANDING_COMPONENT_SASS = "landing/containers/landing-container/landing-container.component.scss";
    private static final String FILE_LANDING_COMPONENT_TS = "landing/containers/landing-container/landing-container.component.ts";
    private static final String FILE_LANDING_COMPONENT_SPEC_TS = "landing/containers/landing-container/landing-container.component.spec.ts";
    private final FreemarkerService freemarkerService;

    public OnceLandingModuleExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void export(Path generationPath) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        this.exportLandingModuleTs(generationPath, dataModel);
        this.exportLandingRoutingModuleTs(generationPath, dataModel);
        this.exportLandingContainerComponentHtml(generationPath, dataModel);
        this.exportLandingContainerComponentSass(generationPath, dataModel);
        this.exportLandingContainerComponentTs(generationPath, dataModel);
        this.exportLandingContainerComponentSpecTs(generationPath, dataModel);
    }

    private void exportLandingModuleTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_MODULE_TS, Paths.get(generationPath.toString(), FILE_LANDING_MODULE_TS));
    }

    private void exportLandingRoutingModuleTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_ROUTING_MODULE_TS, Paths.get(generationPath.toString(), FILE_LANDING_ROUTING_MODULE_TS));
    }

    private void exportLandingContainerComponentHtml(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_COMPONENT_HTML, Paths.get(generationPath.toString(), FILE_LANDING_COMPONENT_HTML));
    }

    private void exportLandingContainerComponentSass(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_COMPONENT_SCSS, Paths.get(generationPath.toString(), FILE_LANDING_COMPONENT_SASS));
    }

    private void exportLandingContainerComponentTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_COMPONENT_TS, Paths.get(generationPath.toString(), FILE_LANDING_COMPONENT_TS));
    }

    private void exportLandingContainerComponentSpecTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_LANDING_COMPONENT_SPEC_TS, Paths.get(generationPath.toString(), FILE_LANDING_COMPONENT_SPEC_TS));
    }
}

