/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.once;

import io.polygenesis.commons.freemarker.FreemarkerService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class OnceEnvironmentsExporter {
    private static final String FTL_ENVIRONMENT_DEV = "polygenesis-angular-generator/src/environments/environment.ts.ftl";
    private static final String FTL_ENVIRONMENT_PROD = "polygenesis-angular-generator/src/environments/environment.prod.ts.ftl";
    private static final String FILE_ENVIRONMENT_DEV = "environment.ts";
    private static final String FILE_ENVIRONMENT_PROD = "environment.prod.ts";
    private final FreemarkerService freemarkerService;

    public OnceEnvironmentsExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void export(Path generationPath) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        this.exportEnvironmentsTs(generationPath, dataModel);
    }

    private void exportEnvironmentsTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_ENVIRONMENT_DEV, Paths.get(generationPath.toString(), FILE_ENVIRONMENT_DEV));
        this.freemarkerService.export(dataModel, FTL_ENVIRONMENT_PROD, Paths.get(generationPath.toString(), FILE_ENVIRONMENT_PROD));
    }
}

