/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy.exporters.once;

import io.polygenesis.commons.freemarker.FreemarkerService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class OnceAppModuleExporter {
    private static final String FTL_APP_MODULE = "polygenesis-angular-generator/src/app/app.module.ts.ftl";
    private static final String FTL_APP_ROUTING_MODULE = "polygenesis-angular-generator/src/app/app-routing.module.ts.ftl";
    private static final String FTL_APP_COMPONENT_HTML = "polygenesis-angular-generator/src/app/app.component.html.ftl";
    private static final String FTL_APP_COMPONENT_SCSS = "polygenesis-angular-generator/src/app/app.component.scss.ftl";
    private static final String FTL_APP_COMPONENT_TS = "polygenesis-angular-generator/src/app/app.component.ts.ftl";
    private static final String FTL_APP_COMPONENT_SPEC_TS = "polygenesis-angular-generator/src/app/app.component.spec.ts.ftl";
    private static final String FILE_APP_MODULE = "app.module.ts";
    private static final String FILE_APP_ROUTING_MODULE = "app-routing.module.ts";
    private static final String FILE_APP_COMPONENT_HTML = "app.component.html";
    private static final String FILE_APP_COMPONENT_SASS = "app.component.scss";
    private static final String FILE_APP_COMPONENT_TS = "app.component.ts";
    private static final String FILE_APP_COMPONENT_SPEC_TS = "app.component.spec.ts";
    private final FreemarkerService freemarkerService;

    public OnceAppModuleExporter(FreemarkerService freemarkerService) {
        this.freemarkerService = freemarkerService;
    }

    public void export(Path generationPath) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        this.exportAppModule(generationPath, dataModel);
        this.exportAppRoutingModule(generationPath, dataModel);
        this.exportAppComponentHtml(generationPath, dataModel);
        this.exportAppComponentSass(generationPath, dataModel);
        this.exportAppComponentTs(generationPath, dataModel);
        this.exportAppComponentSpecTs(generationPath, dataModel);
    }

    private void exportAppModule(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_MODULE, Paths.get(generationPath.toString(), FILE_APP_MODULE));
    }

    private void exportAppRoutingModule(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_ROUTING_MODULE, Paths.get(generationPath.toString(), FILE_APP_ROUTING_MODULE));
    }

    private void exportAppComponentHtml(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_COMPONENT_HTML, Paths.get(generationPath.toString(), FILE_APP_COMPONENT_HTML));
    }

    private void exportAppComponentSass(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_COMPONENT_SCSS, Paths.get(generationPath.toString(), FILE_APP_COMPONENT_SASS));
    }

    private void exportAppComponentTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_COMPONENT_TS, Paths.get(generationPath.toString(), FILE_APP_COMPONENT_TS));
    }

    private void exportAppComponentSpecTs(Path generationPath, Map<String, Object> dataModel) {
        this.freemarkerService.export(dataModel, FTL_APP_COMPONENT_SPEC_TS, Paths.get(generationPath.toString(), FILE_APP_COMPONENT_SPEC_TS));
    }
}

