/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.legacy;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.core.AbstractContextGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.MetamodelGenerator;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.angular.legacy.exporters.once.OnceExporter;
import io.polygenesis.generators.angular.legacy.exporters.reactivestate.StoreExporter;
import io.polygenesis.generators.angular.legacy.exporters.ui.UiExporter;
import io.polygenesis.metamodels.stateredux.Store;
import io.polygenesis.metamodels.stateredux.StoreMetamodelRepository;
import io.polygenesis.models.ui.Feature;
import io.polygenesis.models.ui.UiFeatureMetamodelRepository;
import io.polygenesis.models.ui.UiLayoutContainerMetamodelRepository;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class LegacyAngularContextGenerator
extends AbstractContextGenerator {
    private final OnceExporter onceExporter;
    private final StoreExporter storeExporter;
    private final UiExporter uiExporter;

    public LegacyAngularContextGenerator(Path generationPath, Set<MetamodelGenerator> metamodelGenerators, OnceExporter onceExporter, StoreExporter storeExporter, UiExporter uiExporter) {
        super(generationPath, metamodelGenerators);
        Assertion.isNotNull((Object)onceExporter, (String)"onceExporter is required");
        this.onceExporter = onceExporter;
        Assertion.isNotNull((Object)storeExporter, (String)"StoreExporter is required");
        this.storeExporter = storeExporter;
        Assertion.isNotNull((Object)uiExporter, (String)"UiExporter is required");
        this.uiExporter = uiExporter;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        Path generationPathApp = Paths.get(this.getGenerationPath().toString(), "app");
        this.onceExporter.export(this.getGenerationPath(), (UiLayoutContainerMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, UiLayoutContainerMetamodelRepository.class));
        ((StoreMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, StoreMetamodelRepository.class)).getItems().forEach(store -> this.storeExporter.export(generationPathApp, (Store)store));
        ((UiFeatureMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, UiFeatureMetamodelRepository.class)).getItems().forEach(feature -> this.uiExporter.export(this.getGenerationPath(), (Feature)feature));
    }
}

