/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.context.ui.screen;

import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Generatable;
import io.polygenesis.generators.angular.context.ui.screen.html.ScreenHtmlGenerator;
import io.polygenesis.generators.angular.context.ui.screen.scss.ScreenScssGenerator;
import io.polygenesis.generators.angular.context.ui.screen.spec.ScreenSpecTypescriptGenerator;
import io.polygenesis.generators.angular.context.ui.screen.ts.ScreenTypescriptGenerator;
import io.polygenesis.metamodels.ui.screen.Screen;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ScreenGenerator {
    private final ScreenHtmlGenerator screenHtmlGenerator;
    private final ScreenScssGenerator screenScssGenerator;
    private final ScreenTypescriptGenerator screenTypescriptGenerator;
    private final ScreenSpecTypescriptGenerator screenSpecTypescriptGenerator;

    public ScreenGenerator(ScreenHtmlGenerator screenHtmlGenerator, ScreenScssGenerator screenScssGenerator, ScreenTypescriptGenerator screenTypescriptGenerator, ScreenSpecTypescriptGenerator screenSpecTypescriptGenerator) {
        this.screenHtmlGenerator = screenHtmlGenerator;
        this.screenScssGenerator = screenScssGenerator;
        this.screenTypescriptGenerator = screenTypescriptGenerator;
        this.screenSpecTypescriptGenerator = screenSpecTypescriptGenerator;
    }

    public void generate(Path generationPath, Screen screen) {
        this.screenHtmlGenerator.generate((Generatable)screen, ExportInfo.file((Path)Paths.get(generationPath.toString(), "screens"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)screen.getObjectName().getText()), ".html")), new Object[0]);
        this.screenScssGenerator.generate((Generatable)screen, ExportInfo.file((Path)Paths.get(generationPath.toString(), "screens"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)screen.getObjectName().getText()), ".scss")), new Object[0]);
        this.screenTypescriptGenerator.generate((Generatable)screen, ExportInfo.file((Path)Paths.get(generationPath.toString(), "screens"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)screen.getObjectName().getText()), ".ts")), new Object[0]);
        this.screenSpecTypescriptGenerator.generate((Generatable)screen, ExportInfo.file((Path)Paths.get(generationPath.toString(), "screens"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)screen.getObjectName().getText()), ".spec.ts")), new Object[0]);
    }
}

