/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.context.ui;

import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.ActiveFileExporter;
import io.polygenesis.core.DataTypeTransformer;
import io.polygenesis.core.Exporter;
import io.polygenesis.core.FreemarkerTemplateEngine;
import io.polygenesis.core.TemplateEngine;
import io.polygenesis.generators.angular.context.ui.UiMetamodelGenerator;
import io.polygenesis.generators.angular.context.ui.screen.ScreenGenerator;
import io.polygenesis.generators.angular.context.ui.screen.html.ScreenHtmlGenerator;
import io.polygenesis.generators.angular.context.ui.screen.html.ScreenHtmlTransformer;
import io.polygenesis.generators.angular.context.ui.screen.scss.ScreenScssGenerator;
import io.polygenesis.generators.angular.context.ui.screen.scss.ScreenScssTransformer;
import io.polygenesis.generators.angular.context.ui.screen.spec.ScreenSpecTypescriptActivityRegistry;
import io.polygenesis.generators.angular.context.ui.screen.spec.ScreenSpecTypescriptGenerator;
import io.polygenesis.generators.angular.context.ui.screen.spec.ScreenSpecTypescriptMethodTransformer;
import io.polygenesis.generators.angular.context.ui.screen.spec.ScreenSpecTypescriptTransformer;
import io.polygenesis.generators.angular.context.ui.screen.ts.ScreenTypescriptActivityRegistry;
import io.polygenesis.generators.angular.context.ui.screen.ts.ScreenTypescriptGenerator;
import io.polygenesis.generators.angular.context.ui.screen.ts.ScreenTypescriptMethodTransformer;
import io.polygenesis.generators.angular.context.ui.screen.ts.ScreenTypescriptTransformer;
import io.polygenesis.generators.angular.context.ui.widget.WidgetActivityRegistry;
import io.polygenesis.generators.angular.context.ui.widget.WidgetGenerator;
import io.polygenesis.generators.angular.context.ui.widget.WidgetMethodTransformer;
import io.polygenesis.generators.angular.context.ui.widget.WidgetTransformer;
import io.polygenesis.transformers.typescript.TypescriptDataTypeTransformer;
import java.nio.file.Path;

public class UiMetamodelGeneratorFactory {
    private static ScreenGenerator screenGenerator;
    private static WidgetGenerator widgetGenerator;

    private UiMetamodelGeneratorFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static UiMetamodelGenerator newInstance(Path generationPath, PackageName rootPackageName, ContextName contextName) {
        return new UiMetamodelGenerator(generationPath, rootPackageName, contextName, screenGenerator, widgetGenerator);
    }

    static {
        FreemarkerTemplateEngine templateEngine = new FreemarkerTemplateEngine();
        ActiveFileExporter exporter = new ActiveFileExporter();
        TypescriptDataTypeTransformer dataTypeTransformer = new TypescriptDataTypeTransformer();
        ScreenHtmlGenerator screenHtmlGenerator = new ScreenHtmlGenerator(new ScreenHtmlTransformer((DataTypeTransformer)dataTypeTransformer), (TemplateEngine)templateEngine, (Exporter)exporter);
        ScreenScssGenerator screenScssGenerator = new ScreenScssGenerator(new ScreenScssTransformer((DataTypeTransformer)dataTypeTransformer), (TemplateEngine)templateEngine, (Exporter)exporter);
        ScreenTypescriptGenerator screenTypescriptGenerator = new ScreenTypescriptGenerator(new ScreenTypescriptTransformer((DataTypeTransformer)dataTypeTransformer, new ScreenTypescriptMethodTransformer((DataTypeTransformer)dataTypeTransformer, new ScreenTypescriptActivityRegistry())), (TemplateEngine)templateEngine, (Exporter)exporter);
        ScreenSpecTypescriptGenerator screenSpecTypescriptGenerator = new ScreenSpecTypescriptGenerator(new ScreenSpecTypescriptTransformer((DataTypeTransformer)dataTypeTransformer, new ScreenSpecTypescriptMethodTransformer((DataTypeTransformer)dataTypeTransformer, new ScreenSpecTypescriptActivityRegistry())), (TemplateEngine)templateEngine, (Exporter)exporter);
        screenGenerator = new ScreenGenerator(screenHtmlGenerator, screenScssGenerator, screenTypescriptGenerator, screenSpecTypescriptGenerator);
        widgetGenerator = new WidgetGenerator(new WidgetTransformer((DataTypeTransformer)dataTypeTransformer, new WidgetMethodTransformer((DataTypeTransformer)dataTypeTransformer, new WidgetActivityRegistry())), (TemplateEngine)templateEngine, (Exporter)exporter);
    }
}

