/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.context.ui;

import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.AbstractMetamodelGenerator;
import io.polygenesis.core.CoreRegistry;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.MetamodelRepository;
import io.polygenesis.generators.angular.context.ui.screen.ScreenGenerator;
import io.polygenesis.generators.angular.context.ui.widget.WidgetGenerator;
import io.polygenesis.metamodels.ui.UiContextMetamodelRepository;
import io.polygenesis.metamodels.ui.screen.Screen;
import io.polygenesis.metamodels.ui.widget.Widget;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class UiMetamodelGenerator
extends AbstractMetamodelGenerator {
    private final PackageName rootPackageName;
    private final ContextName contextName;
    private final ScreenGenerator screenGenerator;
    private final WidgetGenerator widgetGenerator;

    public UiMetamodelGenerator(Path generationPath, PackageName rootPackageName, ContextName contextName, ScreenGenerator screenGenerator, WidgetGenerator widgetGenerator) {
        super(generationPath);
        this.rootPackageName = rootPackageName;
        this.contextName = contextName;
        this.screenGenerator = screenGenerator;
        this.widgetGenerator = widgetGenerator;
    }

    public PackageName getRootPackageName() {
        return this.rootPackageName;
    }

    public ContextName getContextName() {
        return this.contextName;
    }

    public void generate(Set<MetamodelRepository<?>> modelRepositories) {
        Set features = ((UiContextMetamodelRepository)CoreRegistry.getMetamodelRepositoryResolver().resolve(modelRepositories, UiContextMetamodelRepository.class)).getItems().stream().flatMap(uiContext -> uiContext.getFeatures().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        features.stream().flatMap(feature -> feature.getScreens().stream()).forEach(screen -> this.screenGenerator.generate(this.getGenerationPath(), (Screen)screen));
        features.stream().flatMap(feature -> feature.getWidgets().stream()).forEach(widget -> this.widgetGenerator.generate((Generatable)widget, this.widgetExportInfo(this.getGenerationPath(), (Widget)widget), new Object[0]));
    }

    private ExportInfo widgetExportInfo(Path generationPath, Widget widget) {
        return ExportInfo.file((Path)Paths.get(generationPath.toString(), "widgets"), (String)String.format("%s%s", TextConverter.toUpperCamel((String)widget.getObjectName().getText()), ".ts"));
    }
}

