/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.generators.angular.context;

import io.polygenesis.commons.valueobjects.ContextName;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.MetamodelGenerator;
import io.polygenesis.generators.angular.context.AngularContextGenerator;
import io.polygenesis.generators.angular.context.model.ModelMetamodelGenerator;
import io.polygenesis.generators.angular.context.model.ModelMetamodelGeneratorFactory;
import io.polygenesis.generators.angular.context.ui.UiMetamodelGenerator;
import io.polygenesis.generators.angular.context.ui.UiMetamodelGeneratorFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;

public class AngularContextGeneratorFactory {
    private AngularContextGeneratorFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static AngularContextGenerator newInstance(Path generationPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        LinkedHashSet<MetamodelGenerator> metamodelGenerators = new LinkedHashSet<MetamodelGenerator>();
        metamodelGenerators.add((MetamodelGenerator)AngularContextGeneratorFactory.modelMetamodelGenerator(generationPath.toString(), contextFolder, rootPackageName, contextName));
        metamodelGenerators.add((MetamodelGenerator)AngularContextGeneratorFactory.uiMetamodelGenerator(generationPath.toString(), contextFolder, rootPackageName, contextName));
        return new AngularContextGenerator(generationPath, metamodelGenerators);
    }

    private static ModelMetamodelGenerator modelMetamodelGenerator(String exportPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        return ModelMetamodelGeneratorFactory.newInstance(Paths.get(exportPath, "src", "app", contextFolder), rootPackageName, contextName);
    }

    private static UiMetamodelGenerator uiMetamodelGenerator(String exportPath, String contextFolder, PackageName rootPackageName, ContextName contextName) {
        return UiMetamodelGeneratorFactory.newInstance(Paths.get(exportPath, "src", "app", contextFolder), rootPackageName, contextName);
    }
}

