/*-
 * ==========================LICENSE_START=================================
 * PolyGenesis Platform
 * ========================================================================
 * Copyright (C) 2015 - 2019 Christos Tsakostas, OREGOR LTD
 * ========================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ===========================LICENSE_END==================================
 */

package io.polygenesis.generators.angular.legacy.exporters.ui;

import io.polygenesis.commons.freemarker.FreemarkerService;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.models.ui.Feature;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

/**
 * The type Module exporter.
 *
 * @author Christos Tsakostas
 */
public class UiModuleExporter {

  private final FreemarkerService freemarkerService;

  // ===============================================================================================
  // CONSTRUCTOR(S)
  // ===============================================================================================

  /**
   * Instantiates a new Ui module exporter.
   *
   * @param freemarkerService the freemarker service
   */
  public UiModuleExporter(FreemarkerService freemarkerService) {
    this.freemarkerService = freemarkerService;
  }

  // ===============================================================================================
  // FUNCTIONALITY
  // ===============================================================================================

  /**
   * Export module.
   *
   * @param generationPathApp the generation app path
   * @param feature the feature
   * @param dataModel the data model
   */
  public void exportModule(Path generationPathApp, Feature feature, Map<String, Object> dataModel) {

    Path contextFeaturePath =
        Paths.get(
            TextConverter.toLowerHyphen(feature.getContextName().getText()),
            TextConverter.toLowerHyphen(feature.getFeatureName().getText()));

    Path modulePath = Paths.get(generationPathApp.toString(), contextFeaturePath.toString());

    PathService.ensurePath(modulePath);

    freemarkerService.export(
        dataModel,
        UiExporterConstants.FTL_MODULE,
        Paths.get(modulePath.toString(), makeModuleFileName(feature)));
  }

  // ===============================================================================================
  // PRIVATE
  // ===============================================================================================

  /**
   * Makes module file name.
   *
   * @return the string
   */
  private String makeModuleFileName(Feature feature) {
    return TextConverter.toLowerHyphen(feature.getFeatureName().getText())
        + UiExporterConstants.POSTFIX_MODULE_TS;
  }
}
