/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.core;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.core.ActiveFileExporter;
import io.polygenesis.core.ExportInfo;
import java.io.ByteArrayOutputStream;
import java.nio.file.Paths;

public class PassiveFileExporter
extends ActiveFileExporter {
    private final Boolean enforceOverwrite = System.getenv().get("enforceOverwrite") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);

    @Override
    public void export(ByteArrayOutputStream byteArrayOutputStream, ExportInfo exportInfo) {
        Assertion.isNotNull((Object)exportInfo, (String)"exportInfo is required");
        Assertion.isNotNull((Object)exportInfo.getGenerationPath(), (String)"exportInfo.getGenerationPath() is required");
        Assertion.isNotNull((Object)exportInfo.getFileName(), (String)"exportInfo.getFileName() is required");
        if (!Paths.get(exportInfo.getGenerationPath().toString(), exportInfo.getFileName()).toFile().exists() || this.enforceOverwrite.booleanValue()) {
            super.export(byteArrayOutputStream, exportInfo);
        }
    }
}

