/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.core;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.core.AbstractExporter;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Exporter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ActiveFileExporter
extends AbstractExporter
implements Exporter {
    public void export(ByteArrayOutputStream byteArrayOutputStream, ExportInfo exportInfo) {
        Assertion.isNotNull((Object)exportInfo, (String)"exportInfo is required");
        Assertion.isNotNull((Object)exportInfo.getGenerationPath(), (String)"exportInfo.getGenerationPath() is required");
        Assertion.isNotNull((Object)exportInfo.getFileName(), (String)"exportInfo.getFileName() is required");
        PathService.ensurePath((Path)exportInfo.getGenerationPath());
        try {
            FileOutputStream outputStream = new FileOutputStream(Paths.get(exportInfo.getGenerationPath().toString(), exportInfo.getFileName()).toString());
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

