/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.core;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.commons.path.PathService;
import io.polygenesis.core.AbstractExporter;
import io.polygenesis.core.ExportInfo;
import io.polygenesis.core.Exporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ActiveFileExporter
extends AbstractExporter
implements Exporter {
    public void export(ByteArrayOutputStream byteArrayOutputStream, ExportInfo exportInfo) {
        Assertion.isNotNull((Object)exportInfo, (String)"exportInfo is required");
        Assertion.isNotNull((Object)exportInfo.getGenerationPath(), (String)"exportInfo.getGenerationPath() is required");
        Assertion.isNotNull((Object)exportInfo.getFileName(), (String)"exportInfo.getFileName() is required");
        PathService.ensurePath((Path)exportInfo.getGenerationPath());
        String formattedContent = this.format(byteArrayOutputStream.toString(Charset.defaultCharset()), exportInfo.getFileName());
        try {
            Files.write(Paths.get(exportInfo.getGenerationPath().toString(), exportInfo.getFileName()), formattedContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

