/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice.internal;

import com.google.common.base.Strings;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderLookup;
import io.pleo.prop.core.Prop;
import io.pleo.prop.core.internal.ParserFactory;
import io.pleo.prop.core.internal.PropFactory;
import io.pleo.prop.guice.internal.FailedToCreatePropException;
import io.pleo.prop.guice.internal.InjectionPointExtractor;
import io.pleo.prop.guice.internal.PropResult;
import io.pleo.prop.guice.internal.RequiredNamedAnnotationException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class PropMappingVisitor
extends DefaultElementVisitor<Map<Key<Prop<?>>, PropResult>> {
    private final InjectionPointExtractor injectionPointExtractor;
    private final PropFactory propFactory;
    private final ParserFactory parserFactory;

    public PropMappingVisitor(Predicate<TypeLiteral<?>> filter, PropFactory propFactory, ParserFactory parserFactory) {
        this.injectionPointExtractor = new InjectionPointExtractor(filter);
        this.propFactory = propFactory;
        this.parserFactory = parserFactory;
    }

    public Map<Key<Prop<?>>, PropResult> visit(Iterable<? extends Element> elements) {
        HashMap mappings = new HashMap();
        for (Element element : elements) {
            Map visitResult = (Map)element.acceptVisitor((ElementVisitor)this);
            if (visitResult == null) continue;
            mappings.putAll(visitResult);
        }
        return mappings;
    }

    public Map<Key<Prop<?>>, PropResult> visit(PrivateElements privateElements) {
        return this.visit(privateElements.getElements());
    }

    public <T> Map<Key<Prop<?>>, PropResult> visit(Binding<T> binding) {
        return this.extractProps((InjectionPoint)binding.acceptTargetVisitor((BindingTargetVisitor)this.injectionPointExtractor));
    }

    public <T> Map<Key<Prop<?>>, PropResult> visit(ProviderLookup<T> providerLookup) {
        return this.extractProps(providerLookup.getDependency().getInjectionPoint());
    }

    private Map<Key<Prop<?>>, PropResult> extractProps(InjectionPoint injectionPoint) {
        if (injectionPoint == null) {
            return new HashMap();
        }
        HashMap extractedProps = new HashMap();
        injectionPoint.getDependencies().stream().map(Dependency::getKey).filter(key -> key.getTypeLiteral().getRawType().equals(Prop.class) && key.getTypeLiteral().getType() instanceof ParameterizedType).map(key -> key).forEach(key -> {
            try {
                Prop<?> value = this.keyToProp((Key<Prop<?>>)key);
                extractedProps.put((Key<Prop<?>>)key, new PropResult(value));
            }
            catch (RuntimeException ex) {
                extractedProps.put((Key<Prop<?>>)key, new PropResult(ex));
            }
        });
        return extractedProps;
    }

    private Prop<?> keyToProp(Key<Prop<?>> key) {
        String propertyName = PropMappingVisitor.getNamedAnnotationValue(key);
        Type type = ((ParameterizedType)key.getTypeLiteral().getType()).getActualTypeArguments()[0];
        Function parser = this.parserFactory.createParserForType(type);
        try {
            return this.propFactory.createProp(propertyName, parser);
        }
        catch (RuntimeException ex) {
            throw new FailedToCreatePropException(propertyName, ex);
        }
    }

    private static String getNamedAnnotationValue(Key<Prop<?>> key) {
        String propName = null;
        if (key.getAnnotation() instanceof javax.inject.Named) {
            propName = ((javax.inject.Named)key.getAnnotation()).value();
        } else if (key.getAnnotation() instanceof Named) {
            propName = ((Named)key.getAnnotation()).value();
        }
        if (Strings.isNullOrEmpty((String)propName)) {
            throw new RequiredNamedAnnotationException(key);
        }
        return propName;
    }
}

