/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.Elements;
import io.pleo.prop.core.Prop;
import io.pleo.prop.core.internal.ParserFactory;
import io.pleo.prop.core.internal.PropFactory;
import io.pleo.prop.guice.internal.PropMappingVisitor;
import io.pleo.prop.guice.internal.PropResult;
import java.util.Map;

public class AutoPropModule
implements Module {
    private final String packagePrefix;
    private final Iterable<? extends Module> modulesToScan;
    private final PropFactory propFactory;
    private final ParserFactory parserFactory;

    public AutoPropModule(String packagePrefix, Iterable<? extends Module> modulesToScan, PropFactory propFactory, ParserFactory parserFactory) {
        this.packagePrefix = packagePrefix;
        this.modulesToScan = modulesToScan;
        this.propFactory = propFactory;
        this.parserFactory = parserFactory;
    }

    public void configure(Binder binder) {
        PropMappingVisitor visitor = new PropMappingVisitor(type -> type.getRawType().getPackage().getName().startsWith(this.packagePrefix), this.propFactory, this.parserFactory);
        Map<Key<Prop<?>>, PropResult> keyToPropMappings = visitor.visit(Elements.getElements(this.modulesToScan));
        keyToPropMappings.entrySet().stream().forEach(kvp -> {
            if (((PropResult)kvp.getValue()).isError()) {
                binder.addError(((PropResult)kvp.getValue()).getError());
            } else {
                binder.bind((Key)kvp.getKey()).toInstance(((PropResult)kvp.getValue()).getProp());
            }
        });
    }
}

