/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice.internal;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.function.Predicate;

public class InjectionPointExtractor
extends DefaultBindingTargetVisitor<Object, InjectionPoint> {
    private final Predicate<TypeLiteral<?>> filter;

    public InjectionPointExtractor(Predicate<TypeLiteral<?>> filter) {
        this.filter = filter;
    }

    public InjectionPoint visit(UntargettedBinding<?> untargettedBinding) {
        return this.getInjectionPointForKey(untargettedBinding.getKey());
    }

    public InjectionPoint visit(LinkedKeyBinding<?> linkedKeyBinding) {
        return this.getInjectionPointForKey(linkedKeyBinding.getLinkedKey());
    }

    public InjectionPoint visit(ProviderKeyBinding<?> providerKeyBinding) {
        return this.getInjectionPointForKey(providerKeyBinding.getProviderKey());
    }

    private InjectionPoint getInjectionPointForKey(Key<?> key) {
        if (this.filter.test(key.getTypeLiteral())) {
            return InjectionPoint.forConstructorOf((TypeLiteral)key.getTypeLiteral());
        }
        return null;
    }
}

