/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.archaius;

import com.netflix.config.Property;
import com.netflix.config.PropertyWrapper;
import io.pleo.prop.archaius.UndefinedPropertyException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingProperty<T>
extends PropertyWrapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(ParsingProperty.class);
    protected final Function<String, T> parser;
    private volatile T value;

    public ParsingProperty(String propName, Function<String, T> parser, T defaultValue) {
        super(propName, defaultValue);
        this.parser = parser;
        this.value = this.parseProperty();
    }

    private T parseProperty() {
        String stringValue = this.prop.getString();
        if (stringValue == null) {
            if (this.defaultValue == null) {
                throw new UndefinedPropertyException((Property<?>)this);
            }
            return (T)this.defaultValue;
        }
        T parsedValue = this.parser.apply(stringValue);
        if (parsedValue == null) {
            throw new UndefinedPropertyException((Property<?>)this);
        }
        return parsedValue;
    }

    protected final void propertyChanged() {
        try {
            T newValue = this.parseProperty();
            this.propertyChanged(this.getValue());
            logger.info("Property '{}' changed from '{}' to '{}'.", new Object[]{this.getName(), this.value, newValue});
            this.value = newValue;
        }
        catch (RuntimeException ex) {
            logger.warn("Failed to parse property '{}' with value '{}'. Keeping last valid value of '{}'.", new Object[]{this.getName(), this.prop.getString(), this.value, ex});
        }
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return "{" + this.getName() + "=" + this.value + '}';
    }
}

