/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Event;
import playn.scene.Layer;
import playn.scene.LayerUtil;
import pythagoras.f.Point;
import pythagoras.f.XY;

public abstract class Interaction<E extends Event.XY>
implements XY {
    private final boolean bubble;
    private boolean canceled;
    private Layer dispatchLayer;
    private Layer capturingLayer;
    private CaptureMode captureMode;
    public final Layer hitLayer;
    public final Point local = new Point();
    public E event;

    public float x() {
        return ((Event.XY)this.event).x;
    }

    public float y() {
        return ((Event.XY)this.event).y;
    }

    public boolean captured() {
        return this.capturingLayer != null;
    }

    public void capture() {
        this.capture(CaptureMode.ONLY);
    }

    public void capture(CaptureMode mode) {
        assert (this.dispatchLayer != null);
        if (this.canceled) {
            throw new IllegalStateException("Cannot capture canceled interaction.");
        }
        if (this.capturingLayer != this.dispatchLayer && this.captured()) {
            throw new IllegalStateException("Interaction already captured by " + this.capturingLayer);
        }
        this.capturingLayer = this.dispatchLayer;
        this.captureMode = mode;
        this.notifyCancel(this.capturingLayer, this.captureMode, this.event);
    }

    public void cancel() {
        if (!this.canceled) {
            this.notifyCancel(null, null, this.event);
            this.canceled = true;
        }
    }

    public Interaction(Layer hitLayer, boolean bubble) {
        assert (hitLayer != null);
        this.hitLayer = hitLayer;
        this.bubble = bubble;
    }

    public String toString() {
        return "Interaction[bubble=" + this.bubble + ", canceled=" + this.canceled + ", capmode=" + (Object)((Object)this.captureMode) + "]\n event=" + this.event + "\n hit=" + this.hitLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(E event) {
        if (this.canceled) {
            return;
        }
        assert (event != null);
        LayerUtil.screenToLayer(this.hitLayer, (XY)this.local.set(((Event.XY)event).x, ((Event.XY)event).y), this.local);
        this.event = event;
        try {
            if (this.bubble) {
                Depth depth = Depth.BELOW;
                for (Layer target = this.hitLayer; target != null; target = target.parent()) {
                    if (target == this.capturingLayer) {
                        depth = Depth.AT;
                    } else if (depth == Depth.AT) {
                        depth = Depth.ABOVE;
                    }
                    if (this.captureMode != null && !this.captureMode.allow(depth)) continue;
                    this.dispatch(target);
                    if (target != this.capturingLayer) continue;
                    depth = Depth.AT;
                }
            } else {
                this.dispatch(this.hitLayer);
            }
        }
        finally {
            this.event = null;
        }
        this.local.set(0.0f, 0.0f);
    }

    void dispatch(Layer layer) {
        if (!layer.hasEventListeners()) {
            return;
        }
        Layer odispatchLayer = this.dispatchLayer;
        this.dispatchLayer = layer;
        try {
            layer.events().emit((Object)this);
        }
        finally {
            this.dispatchLayer = odispatchLayer;
        }
    }

    protected abstract E newCancelEvent(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancel(Layer except, CaptureMode exceptMode, E source) {
        E oldEvent = this.event;
        this.event = this.newCancelEvent(source);
        try {
            if (this.bubble) {
                Depth depth = Depth.BELOW;
                for (Layer target = this.hitLayer; target != null; target = target.parent()) {
                    if (target == except) {
                        depth = Depth.AT;
                    } else if (depth == Depth.AT) {
                        depth = Depth.ABOVE;
                    }
                    if (exceptMode != null && exceptMode.allow(depth)) continue;
                    this.dispatch(target);
                }
            } else if (this.hitLayer != except) {
                this.dispatch(this.hitLayer);
            }
        }
        finally {
            this.event = oldEvent;
        }
    }

    private static enum Depth {
        BELOW,
        AT,
        ABOVE;

    }

    public static enum CaptureMode {
        ONLY{

            @Override
            public boolean allow(Depth depth) {
                return depth == Depth.AT;
            }
        }
        ,
        ABOVE{

            @Override
            public boolean allow(Depth depth) {
                return depth != Depth.BELOW;
            }
        }
        ,
        BELOW{

            @Override
            public boolean allow(Depth depth) {
                return depth != Depth.ABOVE;
            }
        };


        public abstract boolean allow(Depth var1);
    }
}

