/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.QuadBatch;
import playn.core.Surface;
import playn.scene.GroupLayer;
import pythagoras.f.AffineTransform;
import pythagoras.f.FloatMath;
import pythagoras.f.MathUtil;
import pythagoras.f.Point;
import pythagoras.f.Vector;
import pythagoras.f.XY;
import react.Closeable;
import react.Signal;
import react.SignalView;
import react.Value;
import react.ValueView;

public abstract class Layer
implements Closeable {
    public final ValueView<State> state = Value.create((Object)((Object)State.REMOVED));
    protected int flags;
    protected float depth;
    private String name;
    private GroupLayer parent;
    private Signal<Object> events;
    private HitTester hitTester;
    private QuadBatch batch;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation = 0.0f;
    private final AffineTransform transform = new AffineTransform();
    private Origin origin = Origin.FIXED;
    private float originX;
    private float originY;
    protected int tint = -1;
    protected float alpha = 1.0f;

    public Layer() {
        this.setFlag(Flag.VISIBLE, true);
    }

    public String name() {
        if (this.name == null) {
            this.name = this.getClass().getName();
            this.name = this.name.substring(this.name.lastIndexOf(".") + 1).intern();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupLayer parent() {
        return this.parent;
    }

    public Signal<Object> events() {
        if (this.events == null) {
            this.events = new Signal<Object>(){

                protected void connectionAdded() {
                    Layer.this.setInteractive(true);
                }

                protected void connectionRemoved() {
                    if (!this.hasConnections() && Layer.this.deactivateOnNoListeners()) {
                        Layer.this.setInteractive(false);
                    }
                }
            };
        }
        return this.events;
    }

    public boolean hasEventListeners() {
        return this.events != null && this.events.hasConnections();
    }

    public boolean interactive() {
        return this.isSet(Flag.INTERACTIVE);
    }

    public Layer setInteractive(boolean interactive) {
        if (this.interactive() != interactive) {
            if (interactive && this.parent != null) {
                this.parent.setInteractive(interactive);
            }
            this.setFlag(Flag.INTERACTIVE, interactive);
        }
        return this;
    }

    public boolean visible() {
        return this.isSet(Flag.VISIBLE);
    }

    public Layer setVisible(boolean visible) {
        this.setFlag(Flag.VISIBLE, visible);
        return this;
    }

    public boolean disposed() {
        return this.state.get() == State.DISPOSED;
    }

    public void onAdded(SignalView.Listener<? super Layer> action) {
        this.onState(State.ADDED, action);
    }

    public void onRemoved(SignalView.Listener<? super Layer> action) {
        this.onState(State.REMOVED, action);
    }

    public void onDisposed(SignalView.Listener<? super Layer> action) {
        this.onState(State.DISPOSED, action);
    }

    private void onState(final State tgtState, final SignalView.Listener<? super Layer> action) {
        this.state.connect((SignalView.Listener)new SignalView.Listener<State>(){

            public void onEmit(State state) {
                if (state == tgtState) {
                    action.onEmit((Object)Layer.this);
                }
            }
        });
    }

    public void close() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.setState(State.DISPOSED);
        this.setBatch(null);
    }

    public AffineTransform transform() {
        if (this.isSet(Flag.XFDIRTY)) {
            float sina = FloatMath.sin((float)this.rotation);
            float cosa = FloatMath.cos((float)this.rotation);
            float m00 = cosa * this.scaleX;
            float m01 = sina * this.scaleY;
            float m10 = -sina * this.scaleX;
            float m11 = cosa * this.scaleY;
            float tx = this.transform.tx();
            float ty = this.transform.ty();
            this.transform.setTransform(m00, m01, m10, m11, tx, ty);
            this.setFlag(Flag.XFDIRTY, false);
        }
        return this.transform;
    }

    public float alpha() {
        return this.alpha;
    }

    public Layer setAlpha(float alpha) {
        this.alpha = alpha;
        int ialpha = (int)(255.0f * MathUtil.clamp((float)alpha, (float)0.0f, (float)1.0f));
        this.tint = ialpha << 24 | this.tint & 0xFFFFFF;
        return this;
    }

    public int tint() {
        return this.tint;
    }

    public Layer setTint(int tint) {
        this.tint = tint;
        this.alpha = (float)(tint >> 24 & 0xFF) / 255.0f;
        return this;
    }

    public float originX() {
        float width;
        if (this.isSet(Flag.ODIRTY) && (width = this.width()) > 0.0f) {
            this.originX = this.origin.ox(width);
            this.originY = this.origin.oy(this.height());
            this.setFlag(Flag.ODIRTY, false);
        }
        return this.originX;
    }

    public float originY() {
        float height;
        if (this.isSet(Flag.ODIRTY) && (height = this.height()) > 0.0f) {
            this.originX = this.origin.ox(this.width());
            this.originY = this.origin.oy(height);
            this.setFlag(Flag.ODIRTY, false);
        }
        return this.originY;
    }

    public Point origin(Point into) {
        return into.set(this.originX(), this.originY());
    }

    public Vector origin(Vector into) {
        return into.set(this.originX(), this.originY());
    }

    public Layer setOrigin(float x, float y) {
        this.originX = x;
        this.originY = y;
        this.origin = Origin.FIXED;
        this.setFlag(Flag.ODIRTY, false);
        return this;
    }

    public Layer setOrigin(Origin origin) {
        this.origin = origin;
        this.setFlag(Flag.ODIRTY, true);
        return this;
    }

    public float depth() {
        return this.depth;
    }

    public Layer setDepth(float depth) {
        float oldDepth = this.depth;
        if (depth != oldDepth) {
            this.depth = depth;
            if (this.parent != null) {
                this.parent.depthChanged(this, oldDepth);
            }
        }
        return this;
    }

    public float tx() {
        return this.transform.tx();
    }

    public float ty() {
        return this.transform.ty();
    }

    public Point translation(Point into) {
        return into.set(this.transform.tx(), this.transform.ty());
    }

    public Vector translation(Vector into) {
        return into.set(this.transform.tx(), this.transform.ty());
    }

    public Layer setTx(float x) {
        this.transform.setTx(x);
        return this;
    }

    public Layer setTy(float y) {
        this.transform.setTy(y);
        return this;
    }

    public Layer setTranslation(float x, float y) {
        this.transform.setTranslation(x, y);
        return this;
    }

    public Layer setTranslation(XY trans) {
        return this.setTranslation(trans.x(), trans.y());
    }

    public float scaleX() {
        return this.scaleX;
    }

    public float scaleY() {
        return this.scaleY;
    }

    public Vector scale(Vector into) {
        return into.set(this.scaleX, this.scaleY);
    }

    public Layer setScale(float scale) {
        return this.setScale(scale, scale);
    }

    public Layer setScaleX(float sx) {
        if (this.scaleX != sx) {
            this.scaleX = sx;
            this.setFlag(Flag.XFDIRTY, true);
        }
        return this;
    }

    public Layer setScaleY(float sy) {
        if (this.scaleY != sy) {
            this.scaleY = sy;
            this.setFlag(Flag.XFDIRTY, true);
        }
        return this;
    }

    public Layer setScale(float sx, float sy) {
        if (sx != this.scaleX || sy != this.scaleY) {
            this.scaleX = sx;
            this.scaleY = sy;
            this.setFlag(Flag.XFDIRTY, true);
        }
        return this;
    }

    public float rotation() {
        return this.rotation;
    }

    public Layer setRotation(float angle) {
        if (this.rotation != angle) {
            this.rotation = angle;
            this.setFlag(Flag.XFDIRTY, true);
        }
        return this;
    }

    public float width() {
        return 0.0f;
    }

    public float height() {
        return 0.0f;
    }

    public float scaledWidth() {
        return this.scaleX() * this.width();
    }

    public float scaledHeight() {
        return this.scaleX() * this.height();
    }

    public Layer hitTest(Point p) {
        return this.hitTester == null ? this.hitTestDefault(p) : this.hitTester.hitTest(this, p);
    }

    public Layer hitTestDefault(Point p) {
        return p.x >= 0.0f && p.y >= 0.0f && p.x < this.width() && p.y < this.height() ? this : null;
    }

    public Layer setHitTester(HitTester tester) {
        this.hitTester = tester;
        return this;
    }

    public Layer absorbHits() {
        return this.setHitTester(new HitTester(){

            @Override
            public Layer hitTest(Layer layer, Point p) {
                Layer hit = Layer.this.hitTestDefault(p);
                return hit == null ? Layer.this : hit;
            }

            public String toString() {
                return "<all>";
            }
        });
    }

    public Layer setBatch(QuadBatch batch) {
        this.batch = batch;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Surface surf) {
        if (!this.visible()) {
            return;
        }
        int otint = surf.combineTint(this.tint);
        QuadBatch obatch = surf.pushBatch(this.batch);
        surf.concatenate(this.transform(), this.originX(), this.originY());
        try {
            this.paintImpl(surf);
        }
        finally {
            surf.popBatch(obatch);
            surf.setTint(otint);
        }
    }

    protected abstract void paintImpl(Surface var1);

    protected void setState(State state) {
        ((Value)this.state).update((Object)state);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name());
        buf.append(" @ ").append(this.hashCode()).append(" [");
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected void toString(StringBuilder buf) {
        buf.append("tx=").append(this.transform());
        if (this.hitTester != null) {
            buf.append(", hitTester=").append(this.hitTester);
        }
    }

    void onAdd() {
        if (this.disposed()) {
            throw new IllegalStateException("Illegal to use disposed layer: " + this);
        }
        this.setState(State.ADDED);
    }

    void onRemove() {
        this.setState(State.REMOVED);
    }

    void setParent(GroupLayer parent) {
        this.parent = parent;
    }

    protected boolean isSet(Flag flag) {
        return (this.flags & flag.bitmask) != 0;
    }

    protected void setFlag(Flag flag, boolean active) {
        this.flags = active ? (this.flags |= flag.bitmask) : (this.flags &= ~flag.bitmask);
    }

    protected void checkOrigin() {
        if (this.origin != Origin.FIXED) {
            this.setFlag(Flag.ODIRTY, true);
        }
    }

    protected boolean deactivateOnNoListeners() {
        return true;
    }

    protected static enum Flag {
        VISIBLE(1),
        INTERACTIVE(2),
        XFDIRTY(4),
        ODIRTY(8);

        public final int bitmask;

        private Flag(int bitmask) {
            this.bitmask = bitmask;
        }
    }

    public static interface HitTester {
        public Layer hitTest(Layer var1, Point var2);
    }

    public static enum Origin {
        FIXED{

            @Override
            public float ox(float width) {
                return 0.0f;
            }

            @Override
            public float oy(float height) {
                return 0.0f;
            }
        }
        ,
        CENTER{

            @Override
            public float ox(float width) {
                return width / 2.0f;
            }

            @Override
            public float oy(float height) {
                return height / 2.0f;
            }
        }
        ,
        UL{

            @Override
            public float ox(float width) {
                return 0.0f;
            }

            @Override
            public float oy(float height) {
                return 0.0f;
            }
        }
        ,
        UR{

            @Override
            public float ox(float width) {
                return width;
            }

            @Override
            public float oy(float height) {
                return 0.0f;
            }
        }
        ,
        LL{

            @Override
            public float ox(float width) {
                return 0.0f;
            }

            @Override
            public float oy(float height) {
                return height;
            }
        }
        ,
        LR{

            @Override
            public float ox(float width) {
                return width;
            }

            @Override
            public float oy(float height) {
                return height;
            }
        }
        ,
        TC{

            @Override
            public float ox(float width) {
                return width / 2.0f;
            }

            @Override
            public float oy(float height) {
                return 0.0f;
            }
        }
        ,
        BC{

            @Override
            public float ox(float width) {
                return width / 2.0f;
            }

            @Override
            public float oy(float height) {
                return height;
            }
        }
        ,
        LC{

            @Override
            public float ox(float width) {
                return 0.0f;
            }

            @Override
            public float oy(float height) {
                return height / 2.0f;
            }
        }
        ,
        RC{

            @Override
            public float ox(float width) {
                return width;
            }

            @Override
            public float oy(float height) {
                return height / 2.0f;
            }
        };


        public abstract float ox(float var1);

        public abstract float oy(float var1);
    }

    public static enum State {
        REMOVED,
        ADDED,
        DISPOSED;

    }
}

