/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import playn.core.Surface;
import playn.scene.ClippedLayer;
import playn.scene.Layer;
import pythagoras.f.AffineTransform;
import pythagoras.f.IPoint;
import pythagoras.f.MathUtil;
import pythagoras.f.Point;
import pythagoras.util.NoninvertibleTransformException;

public class GroupLayer
extends ClippedLayer
implements Iterable<Layer> {
    private final List<Layer> children = new ArrayList<Layer>();
    private final AffineTransform paintTx = new AffineTransform();
    private final boolean disableClip;

    public GroupLayer() {
        super(0.0f, 0.0f);
        this.disableClip = true;
    }

    public GroupLayer(float width, float height) {
        super(width, height);
        this.disableClip = false;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int children() {
        return this.children.size();
    }

    public Layer childAt(int index) {
        return this.children.get(index);
    }

    public void add(Layer child) {
        GroupLayer parent = child.parent();
        if (parent == this) {
            return;
        }
        int count = this.children.size();
        int index = count == 0 || this.children.get(count - 1).depth() <= child.depth() ? count : this.findInsertion(child.depth());
        if (parent != null) {
            parent.remove(child);
        }
        this.children.add(index, child);
        child.setParent(this);
        if (this.state.get() == Layer.State.ADDED) {
            child.onAdd();
        }
        if (child.interactive()) {
            this.setInteractive(true);
        }
    }

    public void add(Layer child0, Layer child1, Layer ... childN) {
        this.add(child0);
        this.add(child1);
        for (Layer child : childN) {
            this.add(child);
        }
    }

    public void addAt(Layer child, float tx, float ty) {
        this.add(child.setTranslation(tx, ty));
    }

    public void addCenterAt(Layer child, float tx, float ty) {
        this.add(child.setTranslation(tx - child.width() / 2.0f, ty - child.height() / 2.0f));
    }

    public void addFloorAt(Layer child, float tx, float ty) {
        this.add(child.setTranslation(MathUtil.ifloor((float)tx), MathUtil.ifloor((float)ty)));
    }

    public void remove(Layer child) {
        int index = this.findChild(child, child.depth());
        if (index < 0) {
            throw new UnsupportedOperationException("Could not remove Layer because it is not a child of the GroupLayer [group=" + this + ", layer=" + child + "]");
        }
        this.remove(index);
    }

    public void remove(Layer child0, Layer child1, Layer ... childN) {
        this.remove(child0);
        this.remove(child1);
        for (Layer child : childN) {
            this.remove(child);
        }
    }

    public void removeAll() {
        while (!this.children.isEmpty()) {
            this.remove(this.children.size() - 1);
        }
    }

    public void disposeAll() {
        Layer[] toDispose = this.children.toArray(new Layer[this.children.size()]);
        this.removeAll();
        for (Layer child : toDispose) {
            child.close();
        }
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.children.iterator();
    }

    @Override
    public void close() {
        super.close();
        this.disposeAll();
    }

    @Override
    public Layer hitTestDefault(Point point) {
        float x = point.x;
        float y = point.y;
        boolean sawInteractiveChild = false;
        for (int ii = this.children.size() - 1; ii >= 0; --ii) {
            Layer child = this.children.get(ii);
            if (!child.interactive()) continue;
            sawInteractiveChild = true;
            if (!child.visible()) continue;
            try {
                child.transform().inverseTransform((IPoint)point.set(x, y), point);
                point.x += child.originX();
                point.y += child.originY();
                Layer l = child.hitTest(point);
                if (l == null) continue;
                return l;
            }
            catch (NoninvertibleTransformException nte) {
                // empty catch block
            }
        }
        if (!sawInteractiveChild && !this.hasEventListeners()) {
            this.setInteractive(false);
        }
        return super.hitTestDefault(point);
    }

    @Override
    protected boolean disableClip() {
        return this.disableClip;
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", children=").append(this.children.size());
    }

    @Override
    protected void paintClipped(Surface surf) {
        this.paintTx.set(surf.tx());
        List<Layer> children = this.children;
        int ll = children.size();
        for (int ii = 0; ii < ll; ++ii) {
            surf.tx().set(this.paintTx);
            children.get(ii).paint(surf);
        }
    }

    int depthChanged(Layer child, float oldDepth) {
        boolean rightCorrect;
        int oldIndex = this.findChild(child, oldDepth);
        float newDepth = child.depth();
        boolean leftCorrect = oldIndex == 0 || this.children.get(oldIndex - 1).depth() <= newDepth;
        boolean bl = rightCorrect = oldIndex == this.children.size() - 1 || this.children.get(oldIndex + 1).depth() >= newDepth;
        if (leftCorrect && rightCorrect) {
            return oldIndex;
        }
        this.children.remove(oldIndex);
        int newIndex = this.findInsertion(newDepth);
        this.children.add(newIndex, child);
        return newIndex;
    }

    @Override
    void onAdd() {
        super.onAdd();
        int ll = this.children.size();
        for (int ii = 0; ii < ll; ++ii) {
            this.children.get(ii).onAdd();
        }
    }

    @Override
    void onRemove() {
        super.onRemove();
        int ll = this.children.size();
        for (int ii = 0; ii < ll; ++ii) {
            this.children.get(ii).onRemove();
        }
    }

    @Override
    protected boolean deactivateOnNoListeners() {
        return false;
    }

    private void remove(int index) {
        Layer child = this.children.remove(index);
        child.onRemove();
        child.setParent(null);
    }

    private int findChild(Layer child, float depth) {
        int ii;
        int startIdx = this.findInsertion(depth);
        for (ii = startIdx - 1; ii >= 0; --ii) {
            Layer c = this.children.get(ii);
            if (c == child) {
                return ii;
            }
            if (c.depth() != depth) break;
        }
        int ll = this.children.size();
        for (ii = startIdx; ii < ll; ++ii) {
            Layer c = this.children.get(ii);
            if (c == child) {
                return ii;
            }
            if (c.depth() != depth) break;
        }
        return -1;
    }

    private int findInsertion(float depth) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midDepth = this.children.get(mid).depth();
            if (depth > midDepth) {
                low = mid + 1;
                continue;
            }
            if (depth < midDepth) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }
}

